/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.httpbridge.LegacyViewConfiguration;
import org.sonatype.nexus.repository.httpbridge.LegacyViewContributor;
import org.sonatype.nexus.repository.httpbridge.internal.HttpResponseSenderSelector;
import org.sonatype.nexus.repository.httpbridge.internal.RepositoryPath;
import org.sonatype.nexus.repository.httpbridge.internal.ViewServlet;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescriptionHelper;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescriptionRenderer;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class LegacyViewServlet
extends ViewServlet {
    private final List<LegacyViewContributor> legacyViewContributors;
    private final RepositoryManager repositoryManager;

    @Inject
    public LegacyViewServlet(RepositoryManager repositoryManager, HttpResponseSenderSelector httpResponseSenderSelector, DescriptionHelper descriptionHelper, DescriptionRenderer descriptionRenderer, List<LegacyViewContributor> legacyViewContributors, @Named(value="${nexus.repository.sandbox.enable:-true}") boolean sandboxEnabled) {
        super(repositoryManager, httpResponseSenderSelector, descriptionHelper, descriptionRenderer, sandboxEnabled);
        this.legacyViewContributors = (List)Preconditions.checkNotNull(legacyViewContributors);
        this.repositoryManager = repositoryManager;
    }

    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.handleFormatSpecificUri(request, response)) {
            return;
        }
        super.doService(request, response);
    }

    private boolean handleFormatSpecificUri(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        for (LegacyViewContributor legacyViewContributor : this.legacyViewContributors) {
            RepositoryPath path;
            Repository repository;
            LegacyViewConfiguration configuration = legacyViewContributor.contribute();
            if (!this.isFormatSpecific(request, configuration) || !this.repositoryNotFoundOrFormatNotMatched(configuration, repository = this.repositoryManager.get((path = RepositoryPath.parse(request.getPathInfo())).getRepositoryName()))) continue;
            this.send(null, HttpResponses.notFound((String)"Repository not found"), response);
            return true;
        }
        return false;
    }

    private boolean repositoryNotFoundOrFormatNotMatched(LegacyViewConfiguration configuration, Repository repository) {
        return Objects.isNull(repository) || !Objects.equals(configuration.getFormat(), repository.getFormat().getValue());
    }

    private boolean isFormatSpecific(HttpServletRequest request, LegacyViewConfiguration configuration) {
        Matcher matcher = configuration.getRequestPattern().matcher(request.getRequestURI());
        return matcher.matches();
    }
}

