/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import org.apache.commons.io.FilenameUtils;
import org.sonatype.nexus.repository.BadRequestException;

class RepositoryPath {
    private final String repositoryName;
    private final String remainingPath;

    private RepositoryPath(String repositoryName, String remainingPath) {
        this.repositoryName = repositoryName;
        this.remainingPath = remainingPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRemainingPath() {
        return this.remainingPath;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName='" + this.repositoryName + '\'' + ", remainingPath='" + this.remainingPath + '\'' + '}';
    }

    public static RepositoryPath parse(String input) {
        String repo = RepositoryPath.validateAndExtractRepo(input);
        String path = RepositoryPath.validateAndExtractPath(input);
        return new RepositoryPath(repo, path);
    }

    private static String validateAndExtractRepo(String input) {
        if (input == null || input.isEmpty()) {
            throw new BadRequestException("Repository path must not be null or empty");
        }
        if (input.charAt(0) != '/') {
            throw new BadRequestException("Repository path must start with '/'");
        }
        int i = input.indexOf(47, 1);
        if (i == -1) {
            throw new BadRequestException("Repository path must have another '/' after initial '/'");
        }
        String repo = input.substring(1, i);
        if (".".equals(repo) || "..".equals(repo)) {
            throw new BadRequestException("Repository path must not contain a relative token");
        }
        return repo;
    }

    private static String validateAndExtractPath(String input) {
        String path = input.substring(input.indexOf(47, 1), input.length());
        if ((path = FilenameUtils.normalize((String)path, (boolean)true)) == null) {
            throw new BadRequestException("Repository path must not contain a relative token");
        }
        return path;
    }
}

