/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.AuthorizationException;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.repository.BadRequestException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.httpbridge.HttpResponseSender;
import org.sonatype.nexus.repository.httpbridge.internal.HttpHeadersAdapter;
import org.sonatype.nexus.repository.httpbridge.internal.HttpParametersAdapter;
import org.sonatype.nexus.repository.httpbridge.internal.HttpPartIteratorAdapter;
import org.sonatype.nexus.repository.httpbridge.internal.HttpRequestPayloadAdapter;
import org.sonatype.nexus.repository.httpbridge.internal.HttpResponseSenderSelector;
import org.sonatype.nexus.repository.httpbridge.internal.RepositoryPath;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescribeType;
import org.sonatype.nexus.repository.httpbridge.internal.describe.Description;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescriptionHelper;
import org.sonatype.nexus.repository.httpbridge.internal.describe.DescriptionRenderer;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ViewServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewServlet.class);
    private static final String SANDBOX = "sandbox allow-forms allow-modals allow-popups allow-presentation allow-scripts allow-top-navigation";
    @VisibleForTesting
    static final String P_DESCRIBE = "describe";
    protected static final String REPOSITORY_NOT_FOUND_MESSAGE = "Repository not found";
    private final RepositoryManager repositoryManager;
    private final HttpResponseSenderSelector httpResponseSenderSelector;
    private final DescriptionHelper descriptionHelper;
    private final DescriptionRenderer descriptionRenderer;
    private final boolean sandboxEnabled;

    @Inject
    public ViewServlet(RepositoryManager repositoryManager, HttpResponseSenderSelector httpResponseSenderSelector, DescriptionHelper descriptionHelper, DescriptionRenderer descriptionRenderer, @Named(value="${nexus.repository.sandbox.enable:-true}") boolean sandboxEnabled) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.httpResponseSenderSelector = (HttpResponseSenderSelector)((Object)Preconditions.checkNotNull((Object)((Object)httpResponseSenderSelector)));
        this.descriptionHelper = (DescriptionHelper)Preconditions.checkNotNull((Object)descriptionHelper);
        this.descriptionRenderer = (DescriptionRenderer)Preconditions.checkNotNull((Object)descriptionRenderer);
        this.sandboxEnabled = sandboxEnabled;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log.info("Initialized");
    }

    public void destroy() {
        super.destroy();
        log.info("Destroyed");
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String uri = httpRequest.getRequestURI();
        if (httpRequest.getQueryString() != null) {
            uri = String.valueOf(uri) + "?" + httpRequest.getQueryString();
        }
        if (log.isDebugEnabled()) {
            log.debug("Servicing: {} {} ({})", new Object[]{httpRequest.getMethod(), uri, httpRequest.getRequestURL()});
        }
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (Object)uri);
        try {
            try {
                this.doService(httpRequest, httpResponse);
                log.debug("Service completed");
            }
            catch (BadRequestException e) {
                log.warn("Bad request. Reason: {}", (Object)e.getMessage());
                this.send(null, HttpResponses.badRequest((String)e.getMessage()), httpResponse);
                MDC.remove((String)((Object)((Object)this)).getClass().getName());
            }
            catch (Exception e) {
                if (!(e instanceof AuthorizationException)) {
                    log.warn("Failure servicing: {} {}", new Object[]{httpRequest.getMethod(), uri, e});
                }
                Throwables.propagateIfPossible((Throwable)e, ServletException.class, IOException.class);
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
    }

    protected void doService(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (this.sandboxEnabled) {
            httpResponse.setHeader("Content-Security-Policy", SANDBOX);
        }
        RepositoryPath path = RepositoryPath.parse(httpRequest.getPathInfo());
        log.debug("Parsed path: {}", (Object)path);
        Repository repo = this.repository(path.getRepositoryName());
        if (repo == null) {
            this.send(null, HttpResponses.notFound((String)REPOSITORY_NOT_FOUND_MESSAGE), httpResponse);
            return;
        }
        log.debug("Repository: {}", (Object)repo);
        if (!repo.getConfiguration().isOnline()) {
            this.send(null, HttpResponses.serviceUnavailable((String)"Repository offline"), httpResponse);
            return;
        }
        ViewFacet facet = (ViewFacet)repo.facet(ViewFacet.class);
        log.debug("Dispatching to view facet: {}", (Object)facet);
        Request request = this.buildRequest(httpRequest, path.getRemainingPath());
        this.dispatchAndSend(request, facet, this.httpResponseSenderSelector.sender(repo), httpResponse);
    }

    private Request buildRequest(HttpServletRequest httpRequest, String path) {
        Request.Builder builder = new Request.Builder().headers((Headers)new HttpHeadersAdapter(httpRequest)).action(httpRequest.getMethod()).path(path).parameters((Parameters)new HttpParametersAdapter(httpRequest)).payload((Payload)new HttpRequestPayloadAdapter(httpRequest));
        if (HttpPartIteratorAdapter.isMultipart(httpRequest)) {
            builder.multiparts((Iterable)new HttpPartIteratorAdapter(httpRequest));
        }
        Enumeration attributes = httpRequest.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            builder.attribute(name, httpRequest.getAttribute(name));
        }
        return builder.build();
    }

    @VisibleForTesting
    void dispatchAndSend(Request request, ViewFacet facet, HttpResponseSender sender, HttpServletResponse httpResponse) throws Exception {
        Response response = null;
        Exception failure = null;
        try {
            response = facet.dispatch(request);
        }
        catch (Exception e) {
            failure = e;
        }
        String describeFlags = request.getParameters().get(P_DESCRIBE);
        log.trace("Describe flags: {}", (Object)describeFlags);
        if (describeFlags != null) {
            this.send(request, this.describe(request, response, failure, describeFlags), httpResponse);
        } else {
            if (failure != null) {
                throw failure;
            }
            log.debug("Request: {}", (Object)request);
            sender.send(request, response, httpResponse);
        }
    }

    @VisibleForTesting
    Response describe(Request request, Response response, Exception exception, String flags) {
        Description description = new Description((Map<String, Object>)ImmutableMap.of((Object)"path", (Object)request.getPath(), (Object)"nexusUrl", (Object)BaseUrlHolder.get()));
        if (exception != null) {
            this.descriptionHelper.describeException(description, exception);
        }
        this.descriptionHelper.describeRequest(description, request);
        if (response != null) {
            this.descriptionHelper.describeResponse(description, response);
        }
        DescribeType type = DescribeType.parse(flags);
        log.trace("Describe type: {}", (Object)type);
        switch (type) {
            case HTML: {
                String html = this.descriptionRenderer.renderHtml(description);
                return HttpResponses.ok((Payload)new StringPayload(html, "text/html"));
            }
            case JSON: {
                String json = this.descriptionRenderer.renderJson(description);
                return HttpResponses.ok((Payload)new StringPayload(json, "application/json"));
            }
        }
        throw new RuntimeException("Invalid describe-type: " + (Object)((Object)type));
    }

    @VisibleForTesting
    void send(@Nullable Request request, Response response, HttpServletResponse httpResponse) throws ServletException, IOException {
        this.httpResponseSenderSelector.defaultSender().send(request, response, httpResponse);
    }

    @Nullable
    private Repository repository(String name) {
        log.debug("Looking for repository: {}", (Object)name);
        return this.repositoryManager.get(name);
    }
}

