/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal.describe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.StringMultimap;
import org.sonatype.nexus.repository.httpbridge.internal.describe.Description;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
public class DescriptionHelper {
    public void describeRequest(Description desc, Request request) {
        desc.topic("Request");
        desc.addTable("Details", (Map<String, Object>)ImmutableMap.builder().put((Object)"Action", (Object)request.getAction()).put((Object)"path", (Object)request.getPath()).build());
        desc.addTable("Parameters", this.toMap((StringMultimap)request.getParameters()));
        desc.addTable("Headers", this.toMap((StringMultimap)request.getHeaders()));
        desc.addTable("Attributes", this.toMap((Iterable<Map.Entry<String, Object>>)request.getAttributes()));
        if (request.isMultipart()) {
            Iterable parts = request.getMultiparts();
            Preconditions.checkState((parts != null ? 1 : 0) != 0);
            for (Payload payload : parts) {
                desc.addTable("Payload", (Map<String, Object>)this.toMap(payload));
            }
        } else if (request.getPayload() != null) {
            desc.addTable("Payload", (Map<String, Object>)this.toMap(request.getPayload()));
        }
    }

    public void describeResponse(Description desc, Response response) {
        desc.topic("Response");
        Status status = response.getStatus();
        desc.addTable("Status", (Map<String, Object>)ImmutableMap.of((Object)"Code", (Object)status.getCode(), (Object)"Message", (Object)Strings.nullToEmpty((String)status.getMessage())));
        desc.addTable("Headers", this.toMap((StringMultimap)response.getHeaders()));
        desc.addTable("Attributes", this.toMap((Iterable<Map.Entry<String, Object>>)response.getAttributes()));
        Payload payload = response.getPayload();
        if (payload != null) {
            desc.addTable("Payload", (Map<String, Object>)this.toMap(payload));
        }
    }

    private ImmutableMap<String, Object> toMap(Payload payload) {
        return ImmutableMap.of((Object)"Content-Type", (Object)Strings.nullToEmpty((String)payload.getContentType()), (Object)"Size", (Object)payload.getSize());
    }

    public void describeException(Description d, Exception e) {
        d.topic("Exception during handler processing");
        for (Throwable cause : Throwables.getCausalChain((Throwable)e)) {
            d.addTable(cause.getClass().getName(), (Map<String, Object>)ImmutableMap.of((Object)"Message", (Object)Strings.nullToEmpty((String)cause.getMessage())));
        }
    }

    private Map<String, Object> toMap(Iterable<Map.Entry<String, Object>> entries) {
        HashMap table = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : entries) {
            table.put(entry.getKey(), this.convert(entry.getValue()));
        }
        return table;
    }

    private Map<String, Object> toMap(StringMultimap headers) {
        HashMap table = Maps.newHashMap();
        Collection entries = headers.entries();
        for (Map.Entry e : entries) {
            table.put((String)e.getKey(), e.getValue());
        }
        return table;
    }

    private Object convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value.getClass().isPrimitive() || Primitives.isWrapperType(value.getClass())) {
            return value;
        }
        return String.valueOf(value);
    }
}

