/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="docker")
public class DockerBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<String> computeAssetPath(Asset asset, Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            return this.computeComponentPath(asset, component);
        }
        return super.computeAssetPath(asset, null).stream().filter(nameComponent -> !"-".equals(nameComponent)).collect(Collectors.toList());
    }

    public List<String> computeComponentPath(Asset asset, Component component) {
        return super.computeAssetPath(asset, component).stream().filter(name -> !"-".equals(name)).map(name -> "manifests".equals(name) ? "tags" : name).collect(Collectors.toList());
    }
}

