/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.orientechnologies.orient.core.id.ORID;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="docker")
@Singleton
public class DockerComponentDirector
extends ComponentSupport
implements ComponentDirector {
    private final V2ManifestUtil v2ManifestUtil;
    private final AssetEntityAdapter assetEntityAdapter;
    private final BlobStoreManager blobStoreManager;
    private final NodeAccess nodeAccess;

    @Inject
    public DockerComponentDirector(V2ManifestUtil v2ManifestUtil, AssetEntityAdapter assetEntityAdapter, BlobStoreManager blobStoreManager, NodeAccess nodeAccess) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return !component.formatAttributes().contains("layerId");
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    @Transactional
    public Component beforeMove(Component component, List<Asset> assets, Repository source, Repository destination) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        List<String> assetNamesToCopy = this.getAssetsToCopy(tx, component, assets);
        this.maybeCopyAssets(tx, source, destination, assetNamesToCopy);
        return component;
    }

    private List<String> getAssetsToCopy(StorageTx tx, Component component, List<Asset> assets) {
        Preconditions.checkState((assets.size() == 1 ? 1 : 0) != 0, (String)"Docker component must have exactly one asset; component: %s", (Object)component.toStringExternal());
        Asset manifestAsset = assets.get(0);
        String manifestDigest = (String)manifestAsset.formatAttributes().get("content_digest", String.class);
        Preconditions.checkState((manifestDigest != null ? 1 : 0) != 0, (String)"Docker component asset must reference the manifest digest; component: %s, asset: %s", (Object)component.toStringExternal(), (Object)manifestAsset.name());
        String manifestAssetName = String.format("v2/%s/manifests/%s", component.name(), manifestDigest);
        try {
            V2Manifest manifest = this.v2ManifestUtil.readManifest((Supplier<InputStream>)Suppliers.ofInstance((Object)tx.requireBlob(manifestAsset.blobRef()).getInputStream()), manifestAsset.name(), null);
            return Stream.concat(Stream.of(manifestAssetName), manifest.referencedDigests().stream().map(digest -> String.format("v2/-/blobs/%s", digest.toString()))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable read manifest for component: %s", component.toStringExternal()), e);
        }
    }

    private void maybeCopyAssets(StorageTx tx, Repository source, Repository destination, List<String> assetNamesToCopy) {
        ORID sourceBucketId = this.assetEntityAdapter.recordIdentity(this.bucketEntityIdOf(tx, source));
        EntityId destBucketEntityId = this.bucketEntityIdOf(tx, destination);
        ORID destBucketId = this.assetEntityAdapter.recordIdentity(destBucketEntityId);
        for (String assetName : assetNamesToCopy) {
            Asset asset = this.assetEntityAdapter.findByBucketComponentName(tx.getDb(), sourceBucketId, null, assetName);
            this.log.debug("Maybe copying asset: {}, from repository: {}, to repository: {}", new Object[]{assetName, source.getName(), destination.getName()});
            Asset destAsset = this.assetEntityAdapter.findByBucketComponentName(tx.getDb(), destBucketId, null, assetName);
            if (destAsset != null) continue;
            BlobRef blobRef = asset.blobRef();
            asset.setEntityMetadata(null);
            asset.bucketId(destBucketEntityId);
            asset.blobRef(this.copyBlob(blobRef, destination));
            tx.saveAsset(asset);
        }
    }

    private BlobRef copyBlob(BlobRef srcBlobRef, Repository destRepo) {
        Preconditions.checkNotNull((Object)srcBlobRef);
        Preconditions.checkNotNull((Object)destRepo);
        String destBlobStoreName = this.blobStoreNameOf(destRepo);
        String srcBlobStoreName = srcBlobRef.getStore();
        BlobStore srcBlobStore = this.blobStoreOf(srcBlobStoreName, "source");
        BlobStore destBlobStore = this.blobStoreOf(destBlobStoreName, "destination");
        BlobAttributes blobAttributes = srcBlobStore.getBlobAttributes(srcBlobRef.getBlobId());
        blobAttributes.getHeaders().put("Bucket.repo-name", destRepo.getName());
        InputStream srcInputStream = this.inputStreamOf(srcBlobStore, srcBlobRef);
        Blob blob = destBlobStore.create(srcInputStream, blobAttributes.getHeaders());
        return new BlobRef(this.nodeAccess.getId(), destBlobStoreName, blob.getId().asUniqueString());
    }

    private EntityId bucketEntityIdOf(StorageTx storageTx, Repository repository) {
        return Optional.of(storageTx).map(tx -> tx.findBucket(repository)).map(Entity::getEntityMetadata).map(EntityMetadata::getId).orElseThrow(() -> new IllegalStateException("Unable to obtain bucket entity id for repository: " + repository.getConfiguration()));
    }

    private String blobStoreNameOf(Repository repository) {
        return Optional.of(repository).map(Repository::getConfiguration).map(c -> c.attributes("storage")).map(a -> (String)a.get("blobStoreName", String.class)).orElseThrow(() -> new IllegalStateException(String.format("Unable to find blob store name for destination repository: %s", repository.getName())));
    }

    private BlobStore blobStoreOf(String blobStoreName, String identifier) {
        return Optional.of(blobStoreName).map(arg_0 -> ((BlobStoreManager)this.blobStoreManager).get(arg_0)).orElseThrow(() -> new IllegalStateException(String.format("Unable to find %s blob store: %s", identifier, blobStoreName)));
    }

    private InputStream inputStreamOf(BlobStore blobStore, BlobRef blobRef) {
        return Optional.of(blobRef).map(BlobRef::getBlobId).map(r -> blobStore.get(r, true)).map(Blob::getInputStream).orElseThrow(() -> new IllegalStateException(String.format("Unable to get input stream for source blob ref: %s", blobRef)));
    }
}

