/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.HttpConfiguration;
import org.slf4j.Logger;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorRegistrar;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.docker.DockerConnectorFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;
import org.sonatype.nexus.validation.constraint.PortNumber;

@Named
public class DockerConnectorFacetImpl
extends FacetSupport
implements DockerConnectorFacet {
    static final String CONFIG_KEY = "docker";
    private final RepositoryManager repositoryManager;
    private final ConstraintViolationFactory constraintViolationFactory;
    private final ConnectorRegistrar connectorRegistrar;
    private final String nexusContextPath;
    private Config config;
    private ConnectorConfiguration httpConfig;
    private ConnectorConfiguration httpsConfig;

    @Inject
    public DockerConnectorFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, ConnectorRegistrar connectorRegistrar, @Named(value="${nexus-context-path}") String nexusContextPath) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.connectorRegistrar = (ConnectorRegistrar)Preconditions.checkNotNull((Object)connectorRegistrar);
        this.nexusContextPath = String.valueOf((String)Preconditions.checkNotNull((Object)nexusContextPath)) + (nexusContextPath.endsWith("/") ? "" : "/");
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
        Config configToValidate = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        HashSet violations = new HashSet();
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validatePortNotInUse(DockerConnectorFacetImpl.pathOf("httpPort"), configToValidate.httpPort, this.getHttpPort())});
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validatePortNotInUse(DockerConnectorFacetImpl.pathOf("httpsPort"), configToValidate.httpsPort, this.getHttpsPort())});
        ConstraintViolations.maybeAdd(violations, this.validateNotSamePort(DockerConnectorFacetImpl.pathOf("httpPort"), configToValidate.httpPort, DockerConnectorFacetImpl.pathOf("httpsPort"), configToValidate.httpsPort));
        ConstraintViolations.maybePropagate(violations, (Logger)this.log);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doStart() throws Exception {
        if (this.config.httpPort != null) {
            try {
                this.httpConfig = new DockerConnectorConfiguration(this.nexusContextPath, this.getRepository().getName(), HttpScheme.HTTP, this.config.httpPort);
                this.connectorRegistrar.addConnector(this.httpConfig);
            }
            catch (Exception e) {
                this.log.warn("Could not configure HTTP connector on port {} for docker repository {}", new Object[]{this.config.httpPort, this.getRepository().getName(), e});
            }
        }
        if (this.config.httpsPort != null) {
            try {
                this.httpsConfig = new DockerConnectorConfiguration(this.nexusContextPath, this.getRepository().getName(), HttpScheme.HTTPS, this.config.httpsPort);
                this.connectorRegistrar.addConnector(this.httpsConfig);
            }
            catch (Exception e) {
                this.log.warn("Could not configure HTTPS connector on port {} for docker repository {}", new Object[]{this.config.httpsPort, this.getRepository().getName(), e});
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.httpConfig != null) {
            this.connectorRegistrar.removeConnector(this.httpConfig);
        }
        if (this.httpsConfig != null) {
            this.connectorRegistrar.removeConnector(this.httpsConfig);
        }
    }

    @Override
    @Nullable
    public Integer getHttpPort() {
        return this.config == null ? null : this.config.httpPort;
    }

    @Override
    @Nullable
    public Integer getHttpsPort() {
        return this.config == null ? null : this.config.httpsPort;
    }

    @Override
    @Nullable
    public Boolean isForceBasicAuth() {
        return this.config == null ? null : this.config.forceBasicAuth;
    }

    private ConstraintViolation<?> validatePortNotInUse(String path, Integer newPort, Integer oldPort) {
        if (newPort != null) {
            List<Repository> repositories;
            try {
                repositories = this.repositoryManager.browse();
            }
            catch (IllegalStateException illegalStateException) {
                repositories = Collections.emptyList();
            }
            for (Repository repository : repositories) {
                DockerConnectorFacet connectorFacet;
                if (!CONFIG_KEY.equals(repository.getFormat().getValue()) || repository.equals(this.getRepository()) || !newPort.equals((connectorFacet = (DockerConnectorFacet)repository.facet(DockerConnectorFacet.class)).getHttpPort()) && !newPort.equals(connectorFacet.getHttpsPort())) continue;
                return this.constraintViolationFactory.createViolation(path, "Port must be unique (conflicts with repository '" + repository.getName() + "')");
            }
            if (this.connectorRegistrar.unavailablePorts().contains(newPort) && !Objects.equals(newPort, oldPort)) {
                return this.constraintViolationFactory.createViolation(path, "Port is already in use");
            }
        }
        return null;
    }

    private ConstraintViolation<?>[] validateNotSamePort(String httpPortPath, Integer httpPort, String httpsPortPath, Integer httpsPort) {
        if (httpPort != null && httpPort.equals(httpsPort)) {
            return new ConstraintViolation[]{this.constraintViolationFactory.createViolation(httpPortPath, "HTTP and HTTPs ports must be different"), this.constraintViolationFactory.createViolation(httpsPortPath, "HTTP and HTTPs ports must be different")};
        }
        return new ConstraintViolation[0];
    }

    private static String pathOf(String fieldName) {
        return "attributes.docker." + fieldName;
    }

    static class Config {
        @PortNumber
        public Integer httpPort;
        @PortNumber
        public Integer httpsPort;
        public Boolean forceBasicAuth = true;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + '}';
        }
    }

    private static class DockerConnectorConfiguration
    implements ConnectorConfiguration {
        private final String nexusContextPath;
        private final String repositoryName;
        private final HttpScheme scheme;
        private final int port;

        private DockerConnectorConfiguration(String nexusContextPath, String repositoryName, HttpScheme scheme, int port) {
            this.nexusContextPath = nexusContextPath;
            this.repositoryName = repositoryName;
            this.scheme = scheme;
            this.port = port;
        }

        public HttpScheme getScheme() {
            return this.scheme;
        }

        public int getPort() {
            return this.port;
        }

        public HttpConfiguration customize(HttpConfiguration configuration) {
            HttpConfiguration httpConfig = new HttpConfiguration(configuration);
            httpConfig.addCustomizer((connector, channelConfig, request) -> {
                HttpURI uri = request.getHttpURI();
                String version = null;
                if (uri.getPath().startsWith("/v1")) {
                    version = "/v1";
                } else if (uri.getPath().startsWith("/v2")) {
                    version = "/v2";
                }
                if (version != null) {
                    request.setHttpURI(new HttpURI(uri.toString().replaceFirst(version, String.valueOf(this.nexusContextPath) + "repository/" + this.repositoryName + version)));
                    request.setMetaData(request.getMetaData());
                } else {
                    try {
                        request.getResponse().sendError(400, "Not a Docker request");
                        request.setHandled(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return httpConfig;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName=" + this.repositoryName + ", scheme=" + this.scheme + ", port=" + this.port + '}';
        }
    }
}

