/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.storage.ContentValidator;
import org.sonatype.nexus.repository.storage.DefaultContentValidator;

@Named(value="docker")
@Singleton
public class DockerContentValidator
extends ComponentSupport
implements ContentValidator {
    private static final byte[] EMPTY_TAR_FILE = new byte[1024];
    private final DefaultContentValidator defaultContentValidator;
    private final ApplicationDirectories applicationDirectories;
    private final V2ManifestUtil v2ManifestUtil;

    static {
        Arrays.fill(EMPTY_TAR_FILE, (byte)0);
    }

    @Inject
    public DockerContentValidator(DefaultContentValidator defaultContentValidator, ApplicationDirectories applicationDirectories, V2ManifestUtil v2ManifestUtil) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, Supplier<InputStream> contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        this.log.trace("Determining content type for: {} with declaredContentType: {}", (Object)contentName, (Object)declaredContentType);
        if (contentName != null) {
            if (contentName.startsWith("v1/")) {
                return this.v1DetermineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
            }
            if (contentName.startsWith("v2/")) {
                return this.v2DetermineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
            }
        }
        throw new InvalidContentException("Unknown Docker content with name " + contentName);
    }

    @Nonnull
    private String v1DetermineContentType(boolean strictContentTypeValidation, Supplier<InputStream> contentSupplier, @Nullable MimeRulesSource mimeRulesSource, String contentName, @Nullable String declaredContentType) throws IOException {
        if (strictContentTypeValidation && contentName != null && contentName.endsWith("/json")) {
            if (this.isValidJson(contentSupplier, contentName)) {
                return "application/json";
            }
            throw new InvalidContentException("Invalid JSON file: " + contentName);
        }
        if (this.isEmptyDiff(contentSupplier, contentName)) {
            return "application/octet-stream";
        }
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
    }

    @Nonnull
    private String v2DetermineContentType(boolean strictContentTypeValidation, Supplier<InputStream> contentSupplier, @Nullable MimeRulesSource mimeRulesSource, String contentName, @Nullable String declaredContentType) throws IOException {
        if (contentName.startsWith("v2/-/blobs/")) {
            if (this.isValidImageLayer(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType)) {
                return "application/vnd.docker.image.rootfs.diff.tar.gzip";
            }
            if (this.isValidJson(contentSupplier, contentName)) {
                return "application/vnd.docker.container.image.v1+json";
            }
            if (this.isEmptyDiff(contentSupplier, contentName)) {
                return "application/octet-stream";
            }
        } else if (contentName.contains("/manifests/")) {
            try {
                V2Manifest manifest = this.v2ManifestUtil.readManifest(contentSupplier, contentName, declaredContentType);
                return manifest.getMediaType();
            }
            catch (V2Exception.ManifestInvalid e) {
                throw new InvalidContentException("Invalid manifest " + contentName, (Throwable)e);
            }
        }
        if (this.isValidJson(contentSupplier, contentName)) {
            return "application/json";
        }
        throw new InvalidContentException("Invalid docker content " + contentName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEmptyDiff(Supplier<InputStream> contentSupplier, String contentName) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream content = (InputStream)contentSupplier.get();
                try {
                    ByteStreams.readFully((InputStream)content, (byte[])buffer);
                    if (content.available() > 0) {
                        return false;
                    }
                    return Arrays.equals(EMPTY_TAR_FILE, buffer);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (content == null) return false;
                    content.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (EOFException e) {
            this.log.trace("Input is less than 1024 bytes, not an empty diff: {}", (Object)contentName, (Object)e);
            return false;
        }
    }

    private boolean isValidImageLayer(boolean strictContentTypeValidation, Supplier<InputStream> contentSupplier, @Nullable MimeRulesSource mimeRulesSource, String contentName, @Nullable String declaredContentType) throws IOException {
        try {
            String contentType = this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
            this.log.trace("Checking for gzip, Content-Type for: {} detected as: {}", (Object)contentName, (Object)contentType);
            boolean isValidLayer = "application/gzip".equals(contentType);
            if (!isValidLayer) {
                this.log.trace("Falling back to check for x-tar for older(1.8.x) clients on centos");
                isValidLayer = "application/x-tar".equals(contentType);
                this.log.trace("Detected as tar: {}", (Object)isValidLayer);
            }
            return isValidLayer;
        }
        catch (InvalidContentException e) {
            this.log.trace("Input is not detected as an accepted image layer type (gzip or tar): {}", (Object)contentName, (Object)e);
            return false;
        }
    }

    private boolean isValidJson(Supplier<InputStream> contentSupplier, String contentName) throws IOException {
        try {
            DockerFacetUtils.mapper.readValue((InputStream)contentSupplier.get(), DockerFacetUtils.JSON_AS_MAP_TYPE_REF);
            return true;
        }
        catch (JsonProcessingException e) {
            Path path = Files.createTempFile("docker-content-validation-failures", "", new FileAttribute[0]);
            this.log.trace("Invalid JSON file: {}. Content will be written to disk for manual inspect at: {}", new Object[]{contentName, path, e});
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream inputStream = (InputStream)contentSupplier.get();){
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return false;
        }
    }
}

