/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerV1Routes;
import org.sonatype.nexus.repository.docker.internal.DockerV2Routes;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;

public final class DockerFacetUtils {
    public static final TypeReference<Map<String, Object>> JSON_AS_MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<Map<String, String>> V1_TAG_TYPE_REF = new TypeReference<Map<String, String>>(){};
    public static final TypeReference<List<String>> V1_IMAGE_ANCESTRY_TYPE_REF = new TypeReference<List<String>>(){};
    public static final TypeReference<List<Map<String, Object>>> V1_IMAGE_INDEX_TYPE_REF = new TypeReference<List<Map<String, Object>>>(){};
    public static final ObjectMapper mapper = new ObjectMapper();
    static final String V2_BLOBS = "v2/-/blobs/";
    static final HashAlgorithm DOCKER_DIGEST_ALGORITHM = HashAlgorithm.SHA256;
    static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{DOCKER_DIGEST_ALGORITHM, HashAlgorithm.SHA1});
    private static final Logger log = LoggerFactory.getLogger(DockerFacetUtils.class);
    private static final Pattern VALID_LAYER_ID = Pattern.compile("^([a-f0-9]{16}|[a-f0-9]{64})$");

    static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        String contentDigest = (String)asset.formatAttributes().get("content_digest", String.class);
        if (contentDigest != null) {
            content.getAttributes().set(V2Handlers.DOCKER_CONTENT_DIGEST, (Object)contentDigest);
        }
        return content;
    }

    @Nullable
    static Component findComponent(StorageTx tx, Repository repository, String name, String tag) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)tag).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    static Asset findAssetByContentDigest(StorageTx tx, Bucket bucket, DockerDigest digest) {
        String digestProp = String.format("%s[%s][%s]", "attributes", "docker", "content_digest");
        return tx.findAssetWithProperty(digestProp, (Object)digest.toString(), bucket);
    }

    static Component getOrCreateTagComponent(StorageTx tx, Bucket bucket, Repository repository, String name, String tag) {
        Component tagComponent = DockerFacetUtils.findComponent(tx, repository, name, tag);
        if (tagComponent == null) {
            tagComponent = ((Component)tx.createComponent(bucket, repository.getFormat()).name(name)).version(tag);
            NestedAttributesMap formatAttributes = tagComponent.formatAttributes();
            formatAttributes.set("imageName", (Object)name);
            formatAttributes.set("imageTag", (Object)tag);
            tx.saveComponent(tagComponent);
        }
        return tagComponent;
    }

    static Asset getOrCreateAsset(StorageTx tx, Bucket bucket, Supplier<Asset> assetCreator, String assetName, DockerDigest digest) {
        NestedAttributesMap formatAttributes;
        Asset asset = DockerFacetUtils.findAsset(tx, bucket, assetName);
        if (asset == null) {
            asset = (Asset)assetCreator.get();
            asset.name(assetName);
            formatAttributes = asset.formatAttributes();
            formatAttributes.set("asset_kind", (Object)AssetKind.MANIFEST.name());
        } else {
            formatAttributes = asset.formatAttributes();
        }
        if (digest != null) {
            formatAttributes.set("content_digest", (Object)digest.toString());
        }
        return asset;
    }

    static Asset getOrCreateTagAsset(StorageTx tx, Bucket bucket, Component tagComponent, String name, String tag, DockerDigest digest) {
        return DockerFacetUtils.getOrCreateAsset(tx, bucket, (Supplier<Asset>)((Supplier)() -> tx.createAsset(bucket, tagComponent)), DockerFacetUtils.tagName(name, tag), digest);
    }

    static Asset getOrCreateManifestAsset(StorageTx tx, Bucket bucket, Format format, String name, DockerDigest digest) {
        return DockerFacetUtils.getOrCreateAsset(tx, bucket, (Supplier<Asset>)((Supplier)() -> tx.createAsset(bucket, format)), DockerFacetUtils.manifestName(name, digest), digest);
    }

    static Map<String, String> readTags(Supplier<InputStream> tagsContent) throws IOException {
        try {
            return (Map)mapper.readValue((InputStream)tagsContent.get(), V1_TAG_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse tags", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    static String readLayerId(Supplier<InputStream> streamSupplier) throws IOException {
        try {
            return DockerFacetUtils.validateLayerId((String)mapper.readValue((InputStream)streamSupplier.get(), String.class));
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer id", (Throwable)e);
            throw new V1Exception.InvalidJson("Invalid data");
        }
    }

    static List<String> readAncestry(Supplier<InputStream> ancestryContent) throws IOException {
        try {
            return (List)mapper.readValue((InputStream)ancestryContent.get(), V1_IMAGE_ANCESTRY_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer ancestry", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    static Map<String, Object> readLayerMetadata(Supplier<InputStream> layerMetadataContent) throws IOException {
        try {
            return (Map)mapper.readValue((InputStream)layerMetadataContent.get(), JSON_AS_MAP_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer metadata", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    static String validateLayerId(String layerId) {
        if (!VALID_LAYER_ID.matcher(layerId).matches()) {
            throw new V1Exception.InvalidImageId();
        }
        return layerId;
    }

    @Nullable
    static Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    static Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        DockerDigest contentDigest = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            String digestStr = (String)contentAttributes.get(V2Handlers.DOCKER_CONTENT_DIGEST, String.class);
            if (!Strings.isNullOrEmpty((String)digestStr)) {
                contentDigest = DockerDigest.parse(digestStr);
            }
            contentType = payload.getContentType();
        }
        return DockerFacetUtils.saveAsset(tx, asset, contentSupplier, contentDigest, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        DockerDigest contentDigest = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            String digestStr = (String)contentAttributes.get(V2Handlers.DOCKER_CONTENT_DIGEST, String.class);
            if (!Strings.isNullOrEmpty((String)digestStr)) {
                contentDigest = DockerDigest.parse(digestStr);
            }
            contentType = payload.getContentType();
        }
        return DockerFacetUtils.saveAsset(tx, asset, tempBlob, contentDigest, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, @Nullable DockerDigest digest, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        HashCode contentDigest;
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        NestedAttributesMap formatAttributes = asset.formatAttributes();
        if (formatAttributes.get("content_digest") == null && (contentDigest = asset.getChecksum(DOCKER_DIGEST_ALGORITHM)) != null) {
            DockerDigest dockerDigest = new DockerDigest(DOCKER_DIGEST_ALGORITHM.name(), contentDigest.toString());
            formatAttributes.set("content_digest", (Object)dockerDigest.toString());
        }
        if (digest != null && !digest.toString().equals(formatAttributes.get("content_digest"))) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        tx.saveAsset(asset);
        return DockerFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, @Nullable DockerDigest digest, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        HashCode contentDigest;
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), tempBlob, null, contentType, false);
        NestedAttributesMap formatAttributes = asset.formatAttributes();
        if (formatAttributes.get("content_digest") == null && (contentDigest = asset.getChecksum(DOCKER_DIGEST_ALGORITHM)) != null) {
            DockerDigest dockerDigest = new DockerDigest(DOCKER_DIGEST_ALGORITHM.name(), contentDigest.toString());
            formatAttributes.set("content_digest", (Object)dockerDigest.toString());
        }
        if (digest != null && !digest.toString().equals(formatAttributes.get("content_digest"))) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        tx.saveAsset(asset);
        return DockerFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    static void validateContentDigest(InputStream content, DockerDigest digest) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)digest);
        Hasher hasher = DOCKER_DIGEST_ALGORITHM.function().newHasher();
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = content;){
            ByteStreams.copy((InputStream)in, (OutputStream)output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!digest.hash().equals(hasher.hash().toString())) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
    }

    static DockerDigest calculateChecksum(StorageTx tx, Asset metadataAsset, Asset layerAsset) throws IOException {
        InputStream in;
        Hasher hasher = DOCKER_DIGEST_ALGORITHM.function().newHasher();
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            in = tx.requireBlob(metadataAsset.requireBlobRef()).getInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        hasher.putString((CharSequence)"\n", StandardCharsets.UTF_8);
        throwable = null;
        var6_8 = null;
        try {
            in = tx.requireBlob(layerAsset.requireBlobRef()).getInputStream();
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return new DockerDigest(DOCKER_DIGEST_ALGORITHM.name(), hasher.hash().toString());
    }

    static String v1layerMetadataName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/json";
    }

    static String v1layerContentName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/layer";
    }

    static String v1layerAncestryName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/ancestry";
    }

    static String v1imagesIndexName(String name) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/images";
    }

    static String v1tagsName(String name) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/tags";
    }

    static String v1tagName(String name, String tag) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/tags/" + tag;
    }

    static String blobName(DockerDigest digest) {
        Preconditions.checkNotNull((Object)digest);
        return V2_BLOBS + digest;
    }

    static String blobAssetRequest(DockerDigest digest, String name) {
        Preconditions.checkNotNull((Object)digest);
        Preconditions.checkNotNull((Object)name);
        return "/v2/" + name + "/blobs/" + digest;
    }

    static String manifestName(String name, DockerDigest digest) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)digest);
        return String.valueOf(DockerV2Routes.V2) + "/" + name + "/manifests/" + digest;
    }

    static String tagName(String name, String tag) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)tag);
        return String.valueOf(DockerV2Routes.V2) + "/" + name + "/manifests/" + tag;
    }

    static String tagListName(String name) {
        Preconditions.checkNotNull((Object)name);
        return String.valueOf(DockerV2Routes.V2) + "/" + name + "/tags/list";
    }

    static String catalogName() {
        return String.valueOf(DockerV2Routes.V2) + "/_catalog";
    }

    private DockerFacetUtils() {
    }
}

