/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.DockerGCFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DockerGCFacetImpl
extends FacetSupport
implements DockerGCFacet {
    private static final String ASSET_KIND_ATTRIBUTE = "attributes.docker.asset_kind";
    private static final String LAYER_ID_ATTRIBUTE = "attributes.docker.layerId";
    private final V2ManifestUtil v2ManifestUtil;
    private final long batchSize;

    @Inject
    public DockerGCFacetImpl(V2ManifestUtil v2ManifestUtil, @Named(value="${nexus.removeUnusedLayers.batchSize:-500}") long batchSize) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.batchSize = batchSize;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteUnusedManifestsAndImages() {
        Repository repository = this.getRepository();
        this.log.info("Garbage collection starting on repository: {}", (Object)repository);
        UnitOfWork.beginBatch((Supplier)((StorageFacet)this.facet(StorageFacet.class)).txSupplier());
        try {
            try {
                this.processRepository(repository);
                this.log.info("Garbage collection completed on repository: {}", (Object)repository);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void processRepository(Repository repository) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        long startTime = System.currentTimeMillis();
        this.handleV1Assets(tx, repository, startTime);
        this.handleV2Assets(tx, repository, startTime);
    }

    @VisibleForTesting
    void handleV1Assets(StorageTx tx, Repository repository, long startTime) {
        CancelableHelper.checkCancellation();
        Iterable components = tx.findComponents(Query.builder().where(LAYER_ID_ATTRIBUTE).isNotNull().build(), Collections.singleton(repository));
        HashSet usedLayerIds = new HashSet();
        for (Component component : components) {
            String layerId;
            CancelableHelper.checkCancellation();
            if (!component.lastUpdated().isBefore(startTime)) continue;
            List layerAncestry = (List)component.formatAttributes().get("layerAncestry");
            if (layerAncestry == null && (layerId = (String)component.formatAttributes().get("layerId")) != null) {
                Asset metadataAsset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), DockerFacetUtils.v1layerMetadataName(layerId));
                layerAncestry = (List)metadataAsset.formatAttributes().get("layerAncestry");
            }
            if (layerAncestry == null) continue;
            usedLayerIds.addAll(layerAncestry);
        }
        CancelableHelper.checkCancellation();
        Iterable assets = tx.findAssets(Query.builder().where(ASSET_KIND_ATTRIBUTE).eq((Object)AssetKind.LAYER_CONTENT.name()).or(ASSET_KIND_ATTRIBUTE).eq((Object)AssetKind.LAYER_METADATA.name()).build(), Collections.singleton(repository));
        long deleted = 0L;
        for (Asset asset : assets) {
            CancelableHelper.checkCancellation();
            if (!asset.lastUpdated().isBefore(startTime) || usedLayerIds.contains(asset.formatAttributes().get("layerId").toString())) continue;
            this.log.debug("Found layer to delete {}", (Object)asset);
            tx.deleteAsset(asset);
            this.maybeCommit(++deleted, tx);
        }
    }

    @VisibleForTesting
    void handleV2Assets(StorageTx tx, Repository repository, long startTime) throws IOException {
        CancelableHelper.checkCancellation();
        Iterable assets = tx.findAssets(Query.builder().where(ASSET_KIND_ATTRIBUTE).eq((Object)AssetKind.MANIFEST.name()).build(), Collections.singleton(repository));
        HashSet<String> taggedManifestDigests = new HashSet<String>();
        HashSet<Asset> digestManifests = new HashSet<Asset>();
        HashSet<String> usedLayerDigests = new HashSet<String>();
        for (Asset asset : assets) {
            CancelableHelper.checkCancellation();
            if (!asset.lastUpdated().isBefore(startTime)) continue;
            if (this.isDigestManifest(asset.name())) {
                digestManifests.add(asset);
                continue;
            }
            taggedManifestDigests.add(asset.formatAttributes().get("content_digest").toString());
            try {
                V2Manifest manifest = this.v2ManifestUtil.readManifest((Supplier<InputStream>)Suppliers.ofInstance((Object)tx.requireBlob(asset.blobRef()).getInputStream()), asset.name(), null);
                for (DockerDigest dockerDigest : manifest.referencedDigests()) {
                    usedLayerDigests.add(dockerDigest.toString());
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to read V2 Manifest for asset {}, {}", (Object)asset, (Object)e.getMessage());
                this.log.debug("Exception is", (Throwable)e);
            }
        }
        long deleted = 0L;
        for (Asset asset : digestManifests) {
            CancelableHelper.checkCancellation();
            if (taggedManifestDigests.contains(asset.formatAttributes().get("content_digest").toString())) continue;
            this.log.debug("Found manifest to delete {}", (Object)asset);
            tx.deleteAsset(asset);
            this.maybeCommit(++deleted, tx);
        }
        CancelableHelper.checkCancellation();
        assets = tx.findAssets(Query.builder().where(ASSET_KIND_ATTRIBUTE).eq((Object)AssetKind.BLOB.name()).build(), Collections.singleton(repository));
        for (Asset asset : assets) {
            CancelableHelper.checkCancellation();
            if (!asset.lastUpdated().isBefore(startTime) || usedLayerDigests.contains(asset.formatAttributes().get("content_digest").toString())) continue;
            this.log.debug("Found blob to delete {}", (Object)asset);
            tx.deleteAsset(asset);
            this.maybeCommit(++deleted, tx);
        }
    }

    private boolean isDigestManifest(String name) {
        return name.contains("manifests/sha256:");
    }

    private void maybeCommit(long count, StorageTx tx) {
        if (count % this.batchSize == 0L) {
            this.log.debug("Committing batch delete");
            tx.commit();
            tx.begin();
        }
    }
}

