/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.docker.UploadManager;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.docker.internal.DockerV1Utility;
import org.sonatype.nexus.repository.docker.internal.InvalidUploadRangeException;
import org.sonatype.nexus.repository.docker.internal.Upload;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.docker.internal.UploadManagerImpl;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V1Handlers;
import org.sonatype.nexus.repository.docker.internal.V2CatalogResult;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.V2TagListResult;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DockerHostedFacetImpl
extends FacetSupport
implements DockerHostedFacet {
    private static final Pattern VALID_TAG = Pattern.compile("^[\\w][\\w.-]{0,127}$");
    private final UploadManager uploadManager;
    private final V2ManifestUtil v2ManifestUtil;

    @Inject
    public DockerHostedFacetImpl(V2ManifestUtil v2ManifestUtil) {
        this.uploadManager = new UploadManagerImpl((Provider<BlobStore>)((Provider)() -> ((StorageFacet)this.facet(StorageFacet.class)).blobStore()));
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    public DockerHostedFacetImpl(UploadManager uploadManager, V2ManifestUtil v2ManifestUtil) {
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    @Override
    @TransactionalTouchBlob
    public Content getImagesIndex(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String imagesIndexAssetName = DockerFacetUtils.v1imagesIndexName(name);
        Asset asset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), imagesIndexAssetName);
        if (asset == null) {
            throw new V1Exception.ImagesNotFound();
        }
        return DockerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void putImagesIndex(String name, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.readImagesIndex((Supplier<InputStream>)tempBlob);
            this.doPutImagesIndex(name, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutImagesIndex(String name, TempBlob imagesIndexContent, Payload payload) throws IOException {
        String imagesIndexAssetName;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset imagesIndexAsset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), imagesIndexAssetName = DockerFacetUtils.v1imagesIndexName(name));
        if (imagesIndexAsset == null) {
            imagesIndexAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            imagesIndexAsset.name(imagesIndexAssetName);
            imagesIndexAsset.formatAttributes().set("asset_kind", (Object)AssetKind.IMAGES.name());
            DockerFacetUtils.saveAsset(tx, imagesIndexAsset, imagesIndexContent, payload);
        } else {
            List<Map<String, Object>> mergedIndex = DockerV1Utility.mergeIndexes(this.readImagesIndex(this.blobStreamSupplier(tx, imagesIndexAsset)), this.readImagesIndex((Supplier<InputStream>)imagesIndexContent));
            byte[] buf = DockerFacetUtils.mapper.writeValueAsBytes(mergedIndex);
            Supplier indexStreamSupplier = () -> new ByteArrayInputStream(buf);
            DockerFacetUtils.saveAsset(tx, imagesIndexAsset, (Supplier<InputStream>)indexStreamSupplier, payload);
        }
    }

    @Override
    @TransactionalTouchBlob
    public Content getLayerMetadata(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        Content content = DockerFacetUtils.toContent(metadataAsset, tx.requireBlob(metadataAsset.requireBlobRef()));
        NestedAttributesMap componentAttributes = metadataAsset.formatAttributes();
        content.getAttributes().set(V1Handlers.X_DOCKER_SIZE, componentAttributes.get(V1Handlers.X_DOCKER_SIZE));
        content.getAttributes().set(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD, componentAttributes.get(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD));
        return content;
    }

    @Override
    public void putLayerMetadata(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutLayerMetadata(layerId, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutLayerMetadata(String layerId, TempBlob layerMetadataContent, Payload payload) throws IOException {
        NestedAttributesMap metadataFormatAttributes;
        Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata((Supplier<InputStream>)layerMetadataContent);
        if (!layerMetadata.containsKey("id")) {
            throw new V1Exception.InvalidLayerMetadata("Missing key 'id' in JSON");
        }
        if (!layerMetadata.get("id").equals(layerId)) {
            throw new V1Exception.InvalidLayerMetadata("JSON data contains invalid id");
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        String parentId = (String)layerMetadata.get("parent");
        Asset parentAsset = null;
        List ancestry = null;
        if (parentId != null && ((parentAsset = DockerFacetUtils.findAsset(tx, bucket, DockerFacetUtils.v1layerMetadataName(parentId))) == null || Boolean.TRUE.equals(parentAsset.formatAttributes().get("inProgress")))) {
            throw new V1Exception.InvalidLayerMetadata("Image depends on a non existing parent");
        }
        if (parentAsset != null) {
            ancestry = (List)parentAsset.formatAttributes().get("ancestry", DockerAttributes.T_ANCESTRY);
        }
        if (ancestry == null) {
            ancestry = Lists.newArrayList();
        }
        ancestry.add(0, layerId);
        Asset metadataAsset = DockerFacetUtils.findAsset(tx, bucket, metadataAssetName);
        if (metadataAsset == null) {
            metadataAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            metadataAsset.name(metadataAssetName);
            metadataFormatAttributes = metadataAsset.formatAttributes();
            metadataFormatAttributes.set("layerId", (Object)layerId);
            metadataFormatAttributes.set("asset_kind", (Object)AssetKind.LAYER_METADATA.name());
            metadataFormatAttributes.set("inProgress", (Object)true);
        } else {
            metadataFormatAttributes = metadataAsset.formatAttributes();
            if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
                throw new V1Exception.ImageAlreadyExists();
            }
            metadataFormatAttributes.remove(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD);
        }
        metadataFormatAttributes.set("parent", (Object)parentId);
        metadataFormatAttributes.set("ancestry", (Object)ancestry);
        metadataFormatAttributes.set("arch", layerMetadata.get("os"));
        metadataFormatAttributes.set("os", layerMetadata.get("architecture"));
        DockerFacetUtils.saveAsset(tx, metadataAsset, layerMetadataContent, payload);
    }

    @Override
    @TransactionalTouchBlob
    public Content getLayerContent(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String layerAssetName = DockerFacetUtils.v1layerContentName(layerId);
        this.findMetadataAsset(tx, layerId);
        Asset layerAsset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), layerAssetName);
        if (layerAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        return DockerFacetUtils.toContent(layerAsset, tx.requireBlob(layerAsset.requireBlobRef()));
    }

    @Override
    public void putLayerContent(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutLayerContent(layerId, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutLayerContent(String layerId, TempBlob layerContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        String layerAssetName = DockerFacetUtils.v1layerContentName(layerId);
        Asset metadataAsset = DockerFacetUtils.findAsset(tx, bucket, metadataAssetName);
        if (metadataAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap metadataFormatAttributes = metadataAsset.formatAttributes();
        if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists();
        }
        Asset layerAsset = DockerFacetUtils.findAsset(tx, bucket, layerAssetName);
        if (layerAsset == null) {
            layerAsset = tx.createAsset(bucket, this.getRepository().getFormat());
            layerAsset.name(layerAssetName);
            NestedAttributesMap layerFormatAttributes = layerAsset.formatAttributes();
            layerFormatAttributes.set("layerId", (Object)layerId);
            layerFormatAttributes.set("asset_kind", (Object)AssetKind.LAYER_CONTENT.name());
        }
        DockerFacetUtils.saveAsset(tx, layerAsset, layerContent, payload);
        metadataFormatAttributes.set(V1Handlers.X_DOCKER_SIZE, (Object)layerAsset.size());
        metadataFormatAttributes.set(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD, (Object)DockerFacetUtils.calculateChecksum(tx, metadataAsset, layerAsset).toString());
        tx.saveAsset(metadataAsset);
    }

    @Override
    public void putLayerChecksum(String layerId, String checksum) {
        DockerFacetUtils.validateLayerId(layerId);
        if (checksum == null) {
            throw new V1Exception.OldDocker(String.valueOf(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD) + " not set");
        }
        if (StringUtils.isBlank((String)checksum)) {
            throw new V1Exception.InvalidChecksum("Missing Image's checksum");
        }
        if (checksum.split(":").length != 2) {
            throw new V1Exception.InvalidChecksum("Invalid checksum format");
        }
        this.doPutLayerChecksum(layerId, checksum);
    }

    @TransactionalStoreMetadata
    protected void doPutLayerChecksum(String layerId, String checksum) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String metadataAssetName = DockerFacetUtils.v1layerMetadataName(layerId);
        Asset metadataAsset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), metadataAssetName);
        if (metadataAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap metadataFormatAttributes = metadataAsset.formatAttributes();
        if (!Boolean.TRUE.equals(metadataFormatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists("Cannot set this image checksum");
        }
        Object actualChecksum = metadataFormatAttributes.get(V1Handlers.X_DOCKER_CHECKSUM_PAYLOAD);
        if (!checksum.equals(actualChecksum)) {
            this.log.error("Wrong checksum. Actual: {}; Expected: {}", actualChecksum, (Object)checksum);
            throw new V1Exception.InvalidChecksum("Checksum mismatch");
        }
        metadataFormatAttributes.remove("inProgress");
        tx.saveAsset(metadataAsset);
    }

    @Override
    @TransactionalTouchMetadata
    public Content getLayerAncestry(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        String where = String.format("%s IS NOT NULL AND %s.%s.%s = :layerId", "component", "attributes", this.getRepository().getFormat(), "layerId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("layerId", layerId);
        Iterable tagAssets = tx.findAssets(where, parameters, (Iterable)ImmutableList.of((Object)this.getRepository()), null);
        for (Asset tagAsset : tagAssets) {
            DockerHostedFacetImpl.maybeMarkDownloaded(tx, tagAsset);
        }
        String ancestry = DockerFacetUtils.mapper.writeValueAsString(metadataAsset.formatAttributes().get("ancestry"));
        return new Content((Payload)new StringPayload(ancestry, "application/json"));
    }

    @Override
    @Transactional
    public Content getTags(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Component> tagComponents = this.findComponents(tx, name);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Component tagComponent : tagComponents) {
            tags.put(tagComponent.version(), (String)tagComponent.formatAttributes().get("layerId", String.class));
        }
        if (tags.isEmpty()) {
            throw new V1Exception.RepositoryNotFound();
        }
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString(tags), "application/json"));
    }

    @Override
    @TransactionalTouchMetadata
    public Content getTag(String name, String tag) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component tagComponent = DockerFacetUtils.findComponent(tx, this.getRepository(), name, tag);
        if (tagComponent == null) {
            throw new V1Exception.TagNotFound();
        }
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Asset tagAsset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), tagAssetName);
        if (tagAsset == null) {
            throw new V1Exception.TagNotFound();
        }
        String layerId = (String)tagComponent.formatAttributes().get("layerId", String.class);
        Content content = new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)layerId), "application/json"));
        Content.extractFromAsset((Asset)tagAsset, DockerFacetUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    public void putTag(String name, String tag, Map<String, String> daemonMetadata, Payload content) throws IOException {
        this.validateTagName(tag);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutTag(name, tag, daemonMetadata, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutTag(String name, String tag, Map<String, String> daemonMetadata, TempBlob tagContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String imageIndexAssetName = DockerFacetUtils.v1imagesIndexName(name);
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Asset imageIndexAsset = DockerFacetUtils.findAsset(tx, bucket, imageIndexAssetName);
        if (imageIndexAsset == null) {
            throw new V1Exception.ImagesNotFound();
        }
        String layerId = DockerFacetUtils.readLayerId((Supplier<InputStream>)tagContent);
        Asset metadataAsset = this.findMetadataAsset(tx, layerId);
        Component tagComponent = DockerFacetUtils.findComponent(tx, this.getRepository(), name, tag);
        if (tagComponent == null) {
            tagComponent = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(tag);
        }
        NestedAttributesMap tagComponentFormatAttributes = tagComponent.formatAttributes();
        tagComponentFormatAttributes.set("imageName", (Object)name);
        tagComponentFormatAttributes.set("imageTag", (Object)tag);
        tagComponentFormatAttributes.set("layerId", (Object)layerId);
        tagComponentFormatAttributes.set("layerAncestry", metadataAsset.formatAttributes().get("ancestry"));
        NestedAttributesMap tagDaemonMetadata = tagComponentFormatAttributes.child("daemonMetadata");
        tagDaemonMetadata.clear();
        for (Map.Entry<String, String> entry : daemonMetadata.entrySet()) {
            tagDaemonMetadata.set(entry.getKey(), (Object)entry.getValue());
        }
        tx.saveComponent(tagComponent);
        Asset tagAsset = DockerFacetUtils.findAsset(tx, bucket, tagAssetName);
        if (tagAsset == null) {
            tagAsset = tx.createAsset(bucket, tagComponent);
            tagAsset.name(tagAssetName);
            tagAsset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
        }
        tagAsset.formatAttributes().set("layerId", (Object)layerId);
        DockerFacetUtils.saveAsset(tx, tagAsset, tagContent, payload);
    }

    private Iterable<Component> findComponents(StorageTx tx, String name) {
        return tx.findComponents(Query.builder().where("name").eq((Object)name).build(), Collections.singletonList(this.getRepository()));
    }

    @Override
    @TransactionalTouchBlob
    public Content getBlob(DockerDigest digest) {
        String blobName;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), blobName = DockerFacetUtils.blobName(digest));
        if (asset == null) {
            throw new V2Exception.BlobNotFound(digest);
        }
        return DockerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteBlob(DockerDigest digest) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String blobName = DockerFacetUtils.blobName(digest);
        Asset asset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), blobName);
        if (asset == null) {
            throw new V2Exception.BlobNotFound(digest);
        }
        tx.deleteAsset(asset);
    }

    @Override
    public String beginBlobUpload(String name) throws IOException {
        Upload upload = this.uploadManager.startUpload(name);
        return upload.getUuid();
    }

    @Override
    public Range<Long> uploadBlobRange(String name, String uuid, Optional<Range<Long>> range, Payload payload) throws IOException {
        try {
            return this.uploadManager.add(name, uuid, range, payload);
        }
        catch (InvalidUploadRangeException e) {
            throw new V2Exception.RangeInvalid(e.getMessage());
        }
    }

    @Override
    @TransactionalStoreBlob
    public UploadCompletion completeBlobUpload(String name, String uuid, DockerDigest digest, Optional<Range<Long>> range, Payload payload) throws IOException {
        Content content;
        long length;
        block13: {
            Upload upload;
            try {
                upload = this.uploadManager.complete(name, uuid, range, payload);
            }
            catch (InvalidUploadRangeException e) {
                throw new V2Exception.RangeInvalid(e.getMessage());
            }
            catch (IllegalStateException e) {
                this.log.warn("Failed to complete upload", (Throwable)e);
                throw new V2Exception.BlobUploadUnknown(e.getMessage());
            }
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            String blobName = DockerFacetUtils.blobName(digest);
            Asset asset = DockerFacetUtils.findAsset(tx, bucket, blobName);
            length = upload.length();
            InputStream inputStream = upload.getInputStream();
            if (asset == null) {
                StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
                Throwable throwable = null;
                Object var17_18 = null;
                try (TempBlob tempBlob = storageFacet.createTempBlob(inputStream, DockerFacetUtils.HASH_ALGORITHMS);){
                    content = this.doPutBlob(DockerFacetUtils.blobName(digest), digest, tempBlob);
                    break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            DockerFacetUtils.validateContentDigest(inputStream, digest);
            this.log.debug("Digest {} already exists, discarding.", (Object)digest);
            content = DockerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
        }
        this.uploadManager.cancel(uuid);
        String location = String.valueOf(BaseUrlHolder.get()) + "/v2/" + name + "/blobs/" + digest;
        return new UploadCompletion(location, (String)content.getAttributes().get(V2Handlers.DOCKER_CONTENT_DIGEST, String.class), "0-" + (length - 1L));
    }

    @Override
    public void deleteUpload(String name, String uuid) throws IOException {
        try {
            this.uploadManager.cancel(uuid);
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to cancel upload", (Throwable)e);
            throw new V2Exception.BlobUploadUnknown(e.getMessage());
        }
    }

    @Override
    public void purgeUploads(Duration age) {
        this.uploadManager.purgeUploads(age);
    }

    @Override
    public long getBlobUploadProgress(String name, String uuid) throws IOException {
        try {
            return this.uploadManager.offset(name, uuid);
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to evaluate upload progress", (Throwable)e);
            throw new V2Exception.BlobUploadUnknown(e.getMessage());
        }
    }

    @Override
    @Transactional
    public Content getCatalog() throws IOException {
        V2CatalogResult catalog = new V2CatalogResult();
        Iterables.addAll(catalog.getRepositories(), this.getUniqueComponentNames());
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)catalog), "application/json"));
    }

    @Override
    @Transactional
    public Content getTagList(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Component> components = this.findComponents(tx, name);
        if (!components.iterator().hasNext()) {
            throw new V2Exception.NameUnknown(name);
        }
        V2TagListResult tagList = new V2TagListResult();
        tagList.setName(name);
        for (Component component : components) {
            tagList.getTags().add(component.version());
        }
        tagList.getTags().sort(null);
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)tagList), "application/json"));
    }

    @Override
    public Content putManifestByTag(String name, String tag, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByTag(name, tag, tempBlob, payload.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByTag(String name, String tag, TempBlob manifestContent, @Nullable String manifestContentType) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((Supplier<InputStream>)manifestContent);
        this.doPutManifestByDigest(name, tag, manifestDigest, manifestContent, manifestContentType);
        Component tagComponent = DockerFacetUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        Asset tagAsset = DockerFacetUtils.getOrCreateTagAsset(tx, bucket, tagComponent, name, tag, manifestDigest);
        return DockerFacetUtils.saveAsset(tx, tagAsset, manifestContent, manifestDigest, "application/json", null);
    }

    @Override
    public Content putManifestByDigest(String name, DockerDigest digest, Payload payload) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, null, digest, tempBlob, payload.getContentType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByDigest(String name, @Nullable String tag, DockerDigest digest, TempBlob manifestContent, @Nullable String manifestContentType) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        V2Manifest manifest = this.v2ManifestUtil.readManifest((Supplier<InputStream>)manifestContent, name, manifestContentType);
        this.validateManifest(tx, name, tag, manifest);
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((Supplier<InputStream>)manifestContent);
        if (!manifestDigest.equals(digest)) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        Asset manifestAsset = DockerFacetUtils.getOrCreateManifestAsset(tx, bucket, this.getRepository().getFormat(), name, manifestDigest);
        return DockerFacetUtils.saveAsset(tx, manifestAsset, manifestContent, manifestDigest, "application/json", null);
    }

    private Iterable<String> getUniqueComponentNames() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String sql = String.format("SELECT DISTINCT(%s) AS %s FROM component WHERE %s=:bucket ORDER BY %s", "name", "name", "bucket", "name");
        ImmutableMap sqlParams = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket));
        return Iterables.transform((Iterable)tx.browse(sql, (Map)sqlParams), doc -> (String)doc.field("name", String.class));
    }

    @Override
    @TransactionalTouchBlob
    public Content getManifestByTag(String name, String tag, V2Manifest.SchemaVersion schemaVersion) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset tagAsset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), DockerFacetUtils.tagName(name, tag));
        if (tagAsset == null) {
            throw new V2Exception.ManifestUnknownByTag(name, tag);
        }
        Content manifestContent = DockerFacetUtils.toContent(tagAsset, tx.requireBlob(tagAsset.requireBlobRef()));
        if (manifestContent != null) {
            Content content = this.v2ManifestUtil.mayDowngrade(manifestContent, name, tag, schemaVersion, this.getRepository());
            Content.extractFromAsset((Asset)tagAsset, DockerFacetUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
            return content;
        }
        throw new V2Exception.ManifestUnknownByTag(name, tag);
    }

    @Override
    @TransactionalTouchBlob
    public Content getManifestByDigest(String name, DockerDigest digest) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset manifestAsset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), DockerFacetUtils.manifestName(name, digest));
        if (manifestAsset == null && (manifestAsset = DockerFacetUtils.findAssetByContentDigest(tx, bucket, digest)) == null) {
            throw new V2Exception.ManifestUnknownByDigest(name, digest);
        }
        return DockerFacetUtils.toContent(manifestAsset, tx.requireBlob(manifestAsset.requireBlobRef()));
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteManifest(String name, DockerDigest digest) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        boolean changed = false;
        if (this.maybeDeleteByContentDigest(tx, bucket, digest, name)) {
            changed = true;
        }
        if (this.maybeDeleteByTag(tx, bucket, digest)) {
            changed = true;
        }
        if (!changed) {
            throw new V2Exception.ManifestUnknownByDigest(name, digest);
        }
    }

    @TransactionalDeleteBlob
    private boolean maybeDeleteByTag(StorageTx tx, Bucket bucket, DockerDigest digest) {
        Asset manifestAsset = DockerFacetUtils.findAssetByContentDigest(tx, bucket, digest);
        if (manifestAsset != null) {
            tx.deleteComponent(tx.findComponent(manifestAsset.componentId()));
            return true;
        }
        return false;
    }

    @TransactionalDeleteBlob
    private boolean maybeDeleteByContentDigest(StorageTx tx, Bucket bucket, DockerDigest digest, String name) throws IOException {
        Asset manifestAsset = DockerFacetUtils.findAsset(tx, bucket, DockerFacetUtils.manifestName(name, digest));
        if (manifestAsset != null) {
            BlobRef blobRef = manifestAsset.requireBlobRef();
            this.v2ManifestUtil.readManifest((Supplier<InputStream>)((Supplier)() -> tx.requireBlob(blobRef).getInputStream()), name, manifestAsset.contentType());
            tx.deleteAsset(manifestAsset);
            return true;
        }
        return false;
    }

    @TransactionalStoreBlob
    protected Content doPutBlob(String name, DockerDigest digest, TempBlob blobContent) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.BLOB.name());
        }
        return DockerFacetUtils.saveAsset(tx, asset, blobContent, digest, "application/gzip", null);
    }

    private V2Manifest validateManifest(StorageTx tx, String name, @Nullable String tag, V2Manifest v2Manifest) throws IOException {
        ArrayList<V2Error> validationErrors = new ArrayList<V2Error>();
        v2Manifest.validateManifest(validationErrors, name, tag);
        List<DockerDigest> digests = v2Manifest.referencedDigests();
        if (!digests.isEmpty()) {
            Bucket bucket = tx.findBucket(this.getRepository());
            for (DockerDigest digest : digests) {
                Asset layerAsset = DockerFacetUtils.findAsset(tx, bucket, DockerFacetUtils.blobName(digest));
                if (layerAsset != null) continue;
                this.log.error("Manifest refers to missing layer: {} for: {}/{} in repository {}", new Object[]{digest, name, tag, this.getRepository().getName()});
                validationErrors.add(V2Error.BLOB_UNKNOWN.withDetail(digest.toString()));
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new V2Exception("Invalid Manifest", 400, validationErrors);
        }
        return v2Manifest;
    }

    private Asset findMetadataAsset(StorageTx tx, String layerId) {
        Asset metadataAsset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), DockerFacetUtils.v1layerMetadataName(layerId));
        if (metadataAsset == null || Boolean.TRUE.equals(metadataAsset.formatAttributes().get("inProgress"))) {
            throw new V1Exception.ImageNotFound();
        }
        return metadataAsset;
    }

    private List<Map<String, Object>> readImagesIndex(Supplier<InputStream> imagesIndexContent) throws IOException {
        try {
            return (List)DockerFacetUtils.mapper.readValue((InputStream)imagesIndexContent.get(), DockerFacetUtils.V1_IMAGE_INDEX_TYPE_REF);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new V1Exception.InvalidJson();
        }
    }

    private void validateTagName(String tag) {
        if (!VALID_TAG.matcher(tag).matches()) {
            throw new V1Exception.InvalidTagName();
        }
    }

    private Supplier<InputStream> blobStreamSupplier(StorageTx tx, Asset asset) {
        return () -> tx.requireBlob(asset.requireBlobRef()).getInputStream();
    }

    private static void maybeMarkDownloaded(StorageTx tx, Asset asset) {
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
    }
}

