/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.docker.internal.DockerNotFound;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class DockerNotFoundHandler
extends ComponentSupport
implements Handler {
    private final DockerNotFound notFound;

    @Inject
    public DockerNotFoundHandler(DockerNotFound dockerNotFound) {
        this.notFound = dockerNotFound;
    }

    public Response handle(Context context) throws Exception {
        Response response;
        String action = context.getRequest().getAction();
        if (this.shouldGenerateNotFoundResponse(action, response = context.proceed())) {
            return this.notFound.generate(context);
        }
        return response;
    }

    private boolean shouldGenerateNotFoundResponse(String action, Response response) {
        return "GET".equals(action) && 404 == response.getStatus().getCode() && response.getPayload() == null;
    }
}

