/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V1Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2FailureResult;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.auth.DockerAuthHttpClientContext;
import org.sonatype.nexus.repository.docker.internal.auth.DockerTokenDecoder;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.constraint.Url;

@Named
public class DockerProxyFacetImpl
extends ProxyFacetSupport {
    static final String X_DOCKER_TOKEN = "X-Docker-Token";
    private static final String CONFIG_KEY = "dockerProxy";
    private final V2ManifestUtil v2ManifestUtil;
    private boolean verifyManifestDigest;
    private Config config;

    @Inject
    public DockerProxyFacetImpl(V2ManifestUtil v2ManifestUtil, @Named(value="${nexus.docker.proxy.verifyManifestDigest:-true}") boolean verifyManifestDigest) {
        this.v2ManifestUtil = v2ManifestUtil;
        this.verifyManifestDigest = verifyManifestDigest;
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        if (this.config.indexUrl != null && !this.config.indexUrl.getPath().endsWith("/")) {
            this.config.indexUrl = this.config.indexUrl.resolve(String.valueOf(this.config.indexUrl.getPath()) + "/");
        }
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected Content getCachedContent(Context context) throws IOException {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case IMAGES: {
                return this.getAsset(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context))));
            }
            case TAGS: {
                return this.getAsset(DockerFacetUtils.v1tagsName(V1Handlers.name(V2Handlers.matcherState(context))));
            }
            case TAG: {
                return this.getAsset(DockerFacetUtils.v1tagName(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context))));
            }
            case LAYER_METADATA: {
                return this.getAsset(DockerFacetUtils.v1layerMetadataName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case LAYER_CONTENT: {
                return this.getAsset(DockerFacetUtils.v1layerContentName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case LAYER_ANCESTRY: {
                return this.getAsset(DockerFacetUtils.v1layerAncestryName(V1Handlers.layerId(V2Handlers.matcherState(context))));
            }
            case SEARCH: {
                return null;
            }
            case MANIFEST: {
                return this.getManifest(context);
            }
            case BLOB: {
                return this.getAsset(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))));
            }
            case TAG_LIST: {
                return this.getAsset(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context))));
            }
            case CATALOG: {
                return this.getAsset(DockerFacetUtils.catalogName());
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        ImmutableMap baseAttributes = ImmutableMap.of((Object)"asset_kind", (Object)assetKind.name());
        try {
            return this.storeByAssetKind(context, content, assetKind, (Map<String, Object>)baseAttributes);
        }
        catch (V1Exception e) {
            String remoteUrl = this.getRemoteUrl().toString();
            throw new V1Exception.InvalidResponseFromRemote(e, remoteUrl, context.getRequest().getPath());
        }
    }

    private Content storeByAssetKind(Context context, Content content, AssetKind assetKind, Map<String, Object> baseAttributes) throws IOException {
        switch (assetKind) {
            case IMAGES: {
                return this.putAsset(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context))), content, baseAttributes);
            }
            case TAGS: {
                return this.putTags(V1Handlers.name(V2Handlers.matcherState(context)), content);
            }
            case TAG: {
                return this.putTag(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context)), content);
            }
            case LAYER_METADATA: {
                return this.putLayerMetadata(V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case LAYER_CONTENT: {
                String layerId = V1Handlers.layerId(V2Handlers.matcherState(context));
                return this.putAsset(DockerFacetUtils.v1layerContentName(layerId), content, (Map<String, Object>)ImmutableMap.builder().putAll(baseAttributes).put((Object)"layerId", (Object)layerId).build());
            }
            case LAYER_ANCESTRY: {
                return this.putAncestry(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case SEARCH: {
                return content;
            }
            case MANIFEST: {
                return this.putManifest(context, content);
            }
            case BLOB: {
                V2Handlers.requireName(V2Handlers.matcherState(context), false);
                return this.putAssetValidatedOnDigest(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))), context, content, baseAttributes);
            }
            case TAG_LIST: {
                return this.putAsset(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context))), content, baseAttributes);
            }
            case CATALOG: {
                return this.putAsset(DockerFacetUtils.catalogName(), content, baseAttributes);
            }
        }
        throw new IllegalStateException();
    }

    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(Context context) {
        Parameters parameters;
        String url = context.getRequest().getPath();
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (AssetKind.SEARCH == assetKind && !(parameters = context.getRequest().getParameters()).isEmpty()) {
            url = String.valueOf(url) + "?" + Joiner.on((String)"&").join(Iterables.transform((Iterable)parameters, (Function)new Function<Map.Entry<String, String>, String>(){

                @Nullable
                public String apply(Map.Entry<String, String> input) {
                    return String.valueOf(input.getKey()) + "=" + input.getValue();
                }
            }));
        }
        return url.substring(1);
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        HttpContext httpContext = this.prepareTokenAuthentication(context);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (AssetKind.IMAGES == assetKind) {
            request.setURI(this.getIndexUri().resolve(this.getUrl(context)));
            request.addHeader(X_DOCKER_TOKEN, Boolean.TRUE.toString());
            if (Config.IndexType.REGISTRY != this.config.indexType) {
                httpContext.setAttribute("nexus.httpclient.ssl.trustStore", (Object)Boolean.TRUE.equals(this.config.useTrustStoreForIndexAccess));
            }
        } else if (AssetKind.SEARCH == assetKind) {
            request.setURI(this.getIndexUri().resolve(this.getUrl(context)));
        } else if (AssetKind.MANIFEST == assetKind) {
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v2+json");
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v1+prettyjws");
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v1+json");
        }
        HttpResponse response = client.execute((HttpUriRequest)request, httpContext);
        int statusCode = response.getStatusLine().getStatusCode();
        if (AssetKind.IMAGES == assetKind && statusCode == 200) {
            this.setAttributeFromHeader(context, response, X_DOCKER_TOKEN);
        }
        if (AssetKind.Version.V1.equals((Object)assetKind.getVersion()) && statusCode == 404) {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            V1Exception reason = this.getReason(assetKind);
            throw new V1Exception.InvalidResponseFromRemote(reason, request.getURI().getHost(), request.getURI().getPath());
        }
        if (AssetKind.Version.V2.equals((Object)assetKind.getVersion()) && statusCode >= 400) {
            try {
                if (response.getEntity() != null) {
                    try {
                        V2FailureResult v2Failure = (V2FailureResult)DockerFacetUtils.mapper.readValue(response.getEntity().getContent(), V2FailureResult.class);
                        if (v2Failure != null && !v2Failure.getErrors().isEmpty()) {
                            throw new V2Exception(statusCode, v2Failure.getErrors().get(0));
                        }
                    }
                    catch (JsonParseException e) {
                        this.log.warn("Could not parse error response {}", (Object)e.getMessage());
                    }
                }
                throw new V2Exception(statusCode, V2Error.mapFromStatus(Status.failure((int)statusCode)));
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly((HttpResponse)response);
                throw throwable;
            }
        }
        return response;
    }

    private V1Exception getReason(AssetKind assetKind) {
        switch (assetKind) {
            case IMAGES: {
                return new V1Exception.ImagesNotFound();
            }
            case TAGS: {
                return new V1Exception.RepositoryNotFound();
            }
            case TAG: {
                return new V1Exception.TagNotFound();
            }
            case LAYER_METADATA: 
            case LAYER_CONTENT: 
            case LAYER_ANCESTRY: {
                return new V1Exception.ImageNotFound();
            }
        }
        throw new IllegalStateException("No case for assetKind: " + assetKind.toString());
    }

    protected Content createContent(Context context, HttpResponse response) {
        Content content = super.createContent(context, response);
        this.setAttributeFromHeader(context, response, V2Handlers.DOCKER_CONTENT_DIGEST);
        return content;
    }

    private void setAttributeFromHeader(Context context, HttpResponse response, String key) {
        Header tokenHeader = response.getFirstHeader(key);
        if (tokenHeader != null) {
            context.getAttributes().set(key, (Object)tokenHeader.getValue());
        }
    }

    private URI getIndexUri() {
        switch (this.config.indexType) {
            case REGISTRY: {
                return this.getRemoteUrl();
            }
            case HUB: {
                return this.getHubUri();
            }
        }
        return this.config.indexUrl;
    }

    private URI getHubUri() {
        return URI.create("https://index.docker.io/");
    }

    private String retrieveToken(Context context) throws AuthenticationException {
        String token = (String)context.getAttributes().get(X_DOCKER_TOKEN, String.class);
        if (token == null) {
            HttpResponse response = null;
            URI indexUri = this.getIndexUri();
            try {
                try {
                    TokenMatcher.State state = V2Handlers.matcherState(context);
                    HttpClient client = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).getHttpClient();
                    HttpGet request = new HttpGet(indexUri.resolve(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(state))));
                    request.addHeader(X_DOCKER_TOKEN, "true");
                    response = this.executeOK(indexUri.toASCIIString(), client, request);
                    if (response.getFirstHeader(X_DOCKER_TOKEN) == null) {
                        throw new AuthenticationException(String.format("Could not retrieve token from %s. %s response header not set", indexUri, X_DOCKER_TOKEN));
                    }
                    token = response.getFirstHeader(X_DOCKER_TOKEN).getValue();
                    context.getAttributes().set(X_DOCKER_TOKEN, (Object)token);
                }
                catch (IOException e) {
                    throw new AuthenticationException(String.format("Could not retrieve token from %s", indexUri), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        return token;
    }

    private String retrieveBearerToken(String realm, String service, String scope) throws AuthenticationException {
        String string;
        HttpResponse response = null;
        try {
            Map parsed;
            String token;
            HttpClient client = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).getHttpClient();
            this.log.trace("Retrieving bearer token for realm: {}, service: {}, scope: {}", new Object[]{realm, service, scope});
            HttpGet request = new HttpGet(this.buildUrl(realm, service, scope));
            Header preemptiveBasicAuth = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).createBasicAuthHeader();
            if (preemptiveBasicAuth != null) {
                request.setHeader(preemptiveBasicAuth);
            }
            if ((token = (String)(parsed = (Map)DockerFacetUtils.mapper.readValue((response = this.executeOK(realm, client, request)).getEntity().getContent(), DockerFacetUtils.V1_TAG_TYPE_REF)).get("token")) == null) {
                throw new AuthenticationException(String.format("Could not retrieve bearer token from %s. Returned token is not set", realm));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Docker token is: {}", (Object)DockerTokenDecoder.dumpToken(token));
            }
            string = token;
        }
        catch (IOException e) {
            try {
                throw new AuthenticationException(String.format("Could not retrieve bearer token from %s", realm), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return string;
    }

    private String buildUrl(String realm, String service, String scope) throws AuthenticationException {
        try {
            URIBuilder uriBuilder = new URIBuilder(realm);
            if (!service.isEmpty()) {
                uriBuilder.addParameter("service", service);
            }
            if (!scope.isEmpty()) {
                uriBuilder.addParameter("scope", scope);
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException(String.format("Could not build url to fetch docker token from %s for repository %s", realm, this.getRepository()), (Throwable)e);
        }
    }

    private HttpResponse executeOK(String from, HttpClient client, HttpGet request) throws IOException, AuthenticationException {
        this.log.debug("Fetching: {}", (Object)request);
        HttpResponse response = client.execute((HttpUriRequest)request);
        this.log.debug("Response: {}", (Object)response);
        StatusLine status = response.getStatusLine();
        this.log.debug("Status: {}", (Object)status);
        if (status.getStatusCode() != 200) {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            throw new AuthenticationException(String.format("Could not retrieve token from %s. Status code: %s", from, status.getStatusCode()));
        }
        return response;
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return DockerFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putAsset(String name, Content content, Map<String, Object> attributes) throws IOException {
        return this.putAsset(name, content, attributes, tempBlob -> {});
    }

    private Content putAsset(String name, Content content, Map<String, Object> attributes, Consumer<TempBlob> beforePutAsset) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            beforePutAsset.accept(tempBlob);
            return this.doPutAsset(name, tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putAssetValidatedOnDigest(String name, Context context, Content content, Map<String, Object> attributes) throws IOException {
        return this.putAsset(name, content, attributes, tempBlob -> this.maybeValidateOnDigest(V2Handlers.matcherState(context), (TempBlob)tempBlob));
    }

    @TransactionalStoreBlob
    protected Content doPutAsset(String name, TempBlob blobContent, Payload payload, Map<String, Object> attributes) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = DockerFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
        }
        if (attributes != null) {
            NestedAttributesMap formatAttributes = asset.formatAttributes();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                formatAttributes.set(entry.getKey(), entry.getValue());
            }
        }
        return DockerFacetUtils.saveAsset(tx, asset, blobContent, payload);
    }

    private Content putTags(String name, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            Map<String, String> tags = DockerFacetUtils.readTags((Supplier<InputStream>)tempBlob);
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                this.doPutLayerIdJson(name, entry);
            }
            return this.doPutAsset(DockerFacetUtils.v1tagsName(name), tempBlob, (Payload)content, (Map<String, Object>)ImmutableMap.of((Object)"asset_kind", (Object)AssetKind.TAG_LIST.name()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doPutLayerIdJson(String name, Map.Entry<String, String> entry) throws IOException {
        String layerIdJson = String.valueOf('\"') + entry.getValue() + '\"';
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(layerIdJson.getBytes(StandardCharsets.UTF_8));){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob((InputStream)in, DockerFacetUtils.HASH_ALGORITHMS);){
                this.doPutTag(name, entry.getKey(), tempBlob, (Payload)new Content((Payload)new StringPayload(layerIdJson, "application/json")));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Content putTag(String name, String tag, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutTag(name, tag, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutTag(String name, String tag, TempBlob tagContent, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String tagAssetName = DockerFacetUtils.v1tagName(name, tag);
        Component tagComponent = DockerFacetUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        String layerId = DockerFacetUtils.readLayerId((Supplier<InputStream>)tagContent);
        tagComponent.formatAttributes().set("layerId", (Object)layerId);
        tx.saveComponent(tagComponent);
        Asset tagAsset = DockerFacetUtils.findAsset(tx, bucket, tagAssetName);
        if (tagAsset == null) {
            tagAsset = tx.createAsset(bucket, tagComponent);
            tagAsset.name(tagAssetName);
            tagAsset.formatAttributes().set("asset_kind", (Object)AssetKind.TAG.name());
        }
        tagAsset.formatAttributes().set("layerId", (Object)layerId);
        return DockerFacetUtils.saveAsset(tx, tagAsset, tagContent, payload);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent docker asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    private Content putAncestry(String name, String layerId, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            List<String> ancestry = DockerFacetUtils.readAncestry((Supplier<InputStream>)tempBlob);
            this.doPutAncestry(name, layerId, ancestry);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            attributes.put("asset_kind", AssetKind.LAYER_ANCESTRY.name());
            return this.doPutAsset(DockerFacetUtils.v1layerAncestryName(layerId), tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreMetadata
    protected void doPutAncestry(String name, String layerId, List<String> ancestry) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String format = this.getRepository().getFormat().getValue();
        Iterable tagComponents = tx.findComponents(Query.builder().where("name").eq((Object)name).and("attributes." + format + "." + "layerId").eq((Object)layerId).build(), Collections.singletonList(this.getRepository()));
        for (Component tagComponent : tagComponents) {
            NestedAttributesMap formatAttributes = tagComponent.formatAttributes();
            List currentAncestry = (List)formatAttributes.get("layerAncestry", DockerAttributes.T_LAYER_ANCESTRY);
            if (currentAncestry != null && currentAncestry.equals(ancestry)) continue;
            formatAttributes.set("layerAncestry", ancestry);
            tx.saveComponent(tagComponent);
        }
    }

    private Content putLayerMetadata(String layerId, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata((Supplier<InputStream>)tempBlob);
            attributes.put("parent", layerMetadata.get("parent"));
            attributes.put("asset_kind", AssetKind.LAYER_METADATA.name());
            return this.doPutAsset(DockerFacetUtils.v1layerMetadataName(layerId), tempBlob, (Payload)content, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content getManifest(Context context) throws IOException {
        TokenMatcher.State state = V2Handlers.matcherState(context);
        String name = V2Handlers.requireName(state);
        String tag = V2Handlers.tag(state);
        V2Manifest.SchemaVersion schemaVersion = V2Handlers.detectClientSchemaVersionPreference(context);
        if (tag != null) {
            return this.getManifestByTag(name, tag, schemaVersion);
        }
        return this.getManifestByDigest(name, V2Handlers.requireDigest(state));
    }

    private Content getManifestByTag(String name, String tag, V2Manifest.SchemaVersion schemaVersion) throws IOException {
        Content manifestContent = this.getAsset(DockerFacetUtils.tagName(name, tag));
        if (manifestContent != null) {
            return manifestContent;
        }
        return null;
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getManifestByDigest(String name, DockerDigest digest) {
        Asset manifestAsset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Content manifestContent = this.getAsset(DockerFacetUtils.manifestName(name, digest));
        if (manifestContent == null && (manifestAsset = DockerFacetUtils.findAssetByContentDigest(tx, tx.findBucket(this.getRepository()), digest)) != null) {
            manifestContent = this.getAsset(manifestAsset.name());
        }
        return manifestContent;
    }

    private Content putManifest(Context context, Content content) throws IOException {
        String tag = V2Handlers.tag(V2Handlers.matcherState(context));
        if (!Strings.isNullOrEmpty((String)tag)) {
            return this.putManifestByTag(V2Handlers.requireName(V2Handlers.matcherState(context)), tag, context, content);
        }
        return this.putManifestByDigest(V2Handlers.requireName(V2Handlers.matcherState(context)), V2Handlers.requireDigest(V2Handlers.matcherState(context)), content.getAttributes(), content);
    }

    private Content putManifestByTag(String name, String tag, Context context, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            DockerDigest manifestDigest = this.fetchTagDigestByContentDigest(context, tag, content.getAttributes(), tempBlob);
            this.doPutManifestByDigest(name, manifestDigest, content.getAttributes(), tempBlob);
            return this.doPutManifestByTag(name, tag, context, content.getAttributes(), tempBlob, manifestDigest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByTag(String name, String tag, Context context, @Nullable AttributesMap contentAttributes, TempBlob manifestContent, DockerDigest manifestDigest) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component tagComponent = DockerFacetUtils.getOrCreateTagComponent(tx, bucket, this.getRepository(), name, tag);
        Asset tagAsset = DockerFacetUtils.getOrCreateTagAsset(tx, bucket, tagComponent, name, tag, manifestDigest);
        return DockerFacetUtils.saveAsset(tx, tagAsset, manifestContent, manifestDigest, "application/json", contentAttributes);
    }

    private Content putManifestByDigest(String name, DockerDigest digest, @Nullable AttributesMap contentAttributes, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, digest, contentAttributes, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutManifestByDigest(String name, DockerDigest digest, @Nullable AttributesMap contentAttributes, TempBlob manifestContent) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((Supplier<InputStream>)manifestContent);
        if (this.verifyManifestDigest && !manifestDigest.equals(digest)) {
            throw new V2Exception.DigestInvalidByMismatch();
        }
        Asset manifestAsset = DockerFacetUtils.getOrCreateManifestAsset(tx, bucket, this.getRepository().getFormat(), name, manifestDigest);
        return DockerFacetUtils.saveAsset(tx, manifestAsset, manifestContent, manifestDigest, "application/json", contentAttributes);
    }

    private HttpContext prepareTokenAuthentication(final Context context) throws IOException {
        return new DockerAuthHttpClientContext(this.getRemoteUrl()){

            @Override
            protected String retrieveToken() throws AuthenticationException {
                return DockerProxyFacetImpl.this.retrieveToken(context);
            }

            @Override
            protected String retrieveBearerToken(String realm, String service, String scope) throws AuthenticationException {
                return DockerProxyFacetImpl.this.retrieveBearerToken(realm, service, scope);
            }
        };
    }

    public boolean shouldIncludeLibraryNamespace() {
        return this.config.indexType.equals((Object)Config.IndexType.HUB);
    }

    protected Content doGet(Context context, @Nullable Content staleContent) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        Content content = super.doGet(context, staleContent);
        if (content != null && context.getAttributes().contains(TokenMatcher.State.class) && assetKind.equals((Object)AssetKind.MANIFEST)) {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            String name = V2Handlers.requireName(state);
            String tag = V2Handlers.tag(state);
            V2Manifest.SchemaVersion clientPreference = V2Handlers.detectClientSchemaVersionPreference(context);
            if (this.v2ManifestUtil.shouldDowngrade(content, name, clientPreference)) {
                this.log.debug("Performing downgrade of content to schemaVersion = 1 for {}", (Object)name);
                DockerDigest configDigest = this.v2ManifestUtil.findConfigDigest(content, name);
                String path = DockerFacetUtils.blobAssetRequest(configDigest, name);
                Request getRequest = new Request.Builder().action("GET").path(path).build();
                try {
                    Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(getRequest);
                    if (!response.getStatus().isSuccessful()) {
                        this.log.error("Manifest configuration file download failed: {}", (Object)response.getStatus());
                        throw new V2Exception.BlobNotFound(configDigest);
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed to retrieve configuration file from remote on path: {}", (Object)path, (Object)e);
                    throw new V2Exception.BlobNotFound(configDigest);
                }
                return this.v2ManifestUtil.mayDowngrade(content, name, tag, clientPreference, this.getRepository());
            }
        }
        return content;
    }

    private void maybeValidateOnDigest(TokenMatcher.State state, TempBlob tempBlob) {
        Map tokens = state.getTokens();
        String requiredAlg = (String)tokens.get("digestAlg");
        String requiredDigest = (String)tokens.get("digestHex");
        if (this.verifyManifestDigest && Objects.nonNull(requiredAlg) && Objects.nonNull(requiredDigest) && !requiredDigest.equals(this.getDigest(requiredAlg, tempBlob))) {
            throw new V2Exception.DigestInvalidByMismatch();
        }
    }

    private String getDigest(String algorithm, TempBlob tempBlob) {
        HashAlgorithm hashAlgorithm = (HashAlgorithm)HashAlgorithm.getHashAlgorithm((String)algorithm).orElseThrow(V2Exception.DigestInvalidByMismatch::new);
        return Optional.ofNullable((HashCode)tempBlob.getHashes().get(hashAlgorithm)).orElseThrow(V2Exception.DigestInvalidByMismatch::new).toString();
    }

    private DockerDigest fetchTagDigestByContentDigest(Context context, String tag, AttributesMap contentAttributes, TempBlob manifestContent) throws IOException {
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((Supplier<InputStream>)manifestContent);
        if (!this.verifyManifestDigest) {
            this.log.debug("Manifest Content Digest verification is disabled, using calculated digest as representing valid content.");
            return manifestDigest;
        }
        if (this.headerDigestMatched(manifestDigest, context, contentAttributes)) {
            return manifestDigest;
        }
        this.log.debug("Unable to get digest of tag {} by response header Docker-Content-Digest or ETag. Calculating digest from remote fetch.", (Object)tag);
        try {
            Content contentByHash = this.fetch(this.urlToRemoteManifestDigest(context, tag, manifestDigest), context, null);
            StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
            Throwable throwable = null;
            Object var9_11 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)contentByHash, DockerFacetUtils.HASH_ALGORITHMS);){
                return this.v2ManifestUtil.manifestDigest((Supplier<InputStream>)tempBlob);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (V2Exception e) {
            if (e.getHttpCode() == 404) {
                this.log.error("Could not fetch the tag {} by its digest {}", new Object[]{tag, manifestDigest, e});
                throw new V2Exception.DigestInvalidByMismatch();
            }
            throw e;
        }
    }

    private String urlToRemoteManifestDigest(Context context, String tag, DockerDigest manifestDigest) {
        String requestPath = context.getRequest().getPath();
        int startIndex = requestPath.startsWith("/") ? 1 : 0;
        return String.valueOf(requestPath.substring(startIndex, requestPath.lastIndexOf(tag))) + manifestDigest.toString();
    }

    private boolean headerDigestMatched(DockerDigest manifestDigest, Context context, AttributesMap contentAttributes) {
        String dockerContentDigest = (String)context.getAttributes().get(V2Handlers.DOCKER_CONTENT_DIGEST, String.class);
        if (Objects.nonNull(dockerContentDigest) && manifestDigest.equals(DockerDigest.parse(dockerContentDigest))) {
            return true;
        }
        String eTag = (String)contentAttributes.get("etag", String.class);
        return Objects.nonNull(eTag) && manifestDigest.equals(DockerDigest.parse(eTag));
    }

    static class Config {
        @NotNull
        public IndexType indexType;
        @Url
        public URI indexUrl;
        public Boolean useTrustStoreForIndexAccess;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "indexType=" + (Object)((Object)this.indexType) + ", indexUrl=" + this.indexUrl + ", useTrustStoreForIndexAccess=" + this.useTrustStoreForIndexAccess + '}';
        }

        public static enum IndexType {
            REGISTRY,
            HUB,
            CUSTOM;

        }
    }
}

