/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.repository.docker.internal.InvalidUploadRangeException;
import org.sonatype.nexus.repository.view.Payload;

public class Upload
extends ComponentSupport {
    public static final String DOCKER_BLOB_CREATOR = "nexus-repository-docker";
    public static final String DOCKER_BLOB_PREFIX = "nexus-repository-docker";
    public static final String DOCKER_BLOB_NAME = "docker-name";
    public static final String DOCKER_BLOB_RANGE = "docker-range";
    private final String uuid;
    private String name;
    private Instant started;
    private final BlobStore blobStore;
    private final List<Blob> blobs;

    public Upload(BlobStore blobStore, String uuid) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uuid) ? 1 : 0) != 0);
        this.uuid = uuid;
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
        this.blobs = blobStore.getDirectPathBlobIdStream(Upload.blobPath(uuid)).sorted(Upload::compareBlobIds).map(arg_0 -> ((BlobStore)blobStore).get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!this.blobs.isEmpty()) {
            this.name = (String)this.blobs.get(0).getHeaders().get(DOCKER_BLOB_NAME);
            this.started = Instant.ofEpochMilli(this.blobs.get(0).getMetrics().getCreationTime().getMillis());
        } else {
            this.name = null;
        }
    }

    public boolean exists() {
        return !this.blobs.isEmpty();
    }

    public void create(String name) throws IOException {
        this.name = name;
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.created-by", (Object)"nexus-repository-docker", (Object)"BlobStore.blob-name", (Object)String.format("%s/%s/0", "nexus-repository-docker", this.uuid), (Object)"BlobStore.direct-path", (Object)"true", (Object)DOCKER_BLOB_NAME, (Object)name, (Object)DOCKER_BLOB_RANGE, (Object)"null");
        Blob blob = this.blobStore.create((InputStream)new ByteArrayInputStream(new byte[0]), (Map)headers);
        this.blobs.add(blob);
        this.started = Instant.ofEpochMilli(blob.getMetrics().getCreationTime().getMillis());
    }

    public Range<Long> addBlob(Optional<Range<Long>> range, Payload payload) throws IOException, InvalidUploadRangeException {
        Preconditions.checkNotNull((Object)payload);
        this.maybeValidateRange(range, payload);
        long initialLength = this.length();
        long timestamp = Instant.now().toEpochMilli();
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.created-by", (Object)"nexus-repository-docker", (Object)"BlobStore.blob-name", (Object)String.format("%s/%s/%d", "nexus-repository-docker", this.uuid, timestamp), (Object)"BlobStore.direct-path", (Object)"true", (Object)DOCKER_BLOB_NAME, (Object)this.getName(), (Object)DOCKER_BLOB_RANGE, (Object)range.map(Upload::formatRange).orElse("null"));
        Blob blob = this.blobStore.create(payload.openInputStream(), (Map)headers);
        long blobContentSize = blob.getMetrics().getContentSize();
        Duration duration = Duration.between(this.started, Instant.now());
        this.log.debug("Upload for: {} with uuid: {} added: {} bytes. Duration of upload so far: {}", new Object[]{this.name, this.uuid, blobContentSize, duration});
        this.blobs.add(blob);
        return Range.closed((Comparable)Long.valueOf(initialLength > 0L ? initialLength - 1L : initialLength), (Comparable)Long.valueOf(initialLength + blobContentSize - 1L));
    }

    public void complete(Optional<Range<Long>> range, Payload payload) throws IOException, InvalidUploadRangeException {
        this.addBlob(range, payload);
        Duration duration = Duration.between(this.started, Instant.now());
        this.log.debug("Upload for: {} with uuid: {} completed. {} bytes total. Duration of upload total: {}", new Object[]{this.name, this.uuid, this.length(), duration});
    }

    public void cleanup() {
        this.blobs.stream().forEach(blob -> {
            boolean bl = this.blobStore.delete(blob.getId(), "Docker upload cleaned up.");
        });
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        List inputStreams = this.blobs.stream().map(Blob::getInputStream).collect(Collectors.toList());
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    public long length() {
        return this.blobs.stream().map(blob -> blob.getMetrics().getContentSize()).reduce(0L, (l1, l2) -> l1 + l2);
    }

    private void maybeValidateRange(Optional<Range<Long>> range, Payload payload) throws InvalidUploadRangeException {
        long beginRange;
        Range expectedRange;
        if (range.isPresent() && payload.getSize() > 0L && !(expectedRange = Range.closed((Comparable)Long.valueOf(beginRange = this.length()), (Comparable)Long.valueOf(beginRange + payload.getSize() - 1L))).equals(range.get())) {
            throw new InvalidUploadRangeException(String.format("Range out of bounds: %s. Expected Range: %s", Upload.formatRange(range.get()), Upload.formatRange((Range<Long>)expectedRange)));
        }
    }

    private static String formatRange(Range<Long> range) {
        return String.valueOf(String.valueOf(range.lowerEndpoint())) + '-' + range.upperEndpoint();
    }

    private static Long timestamp(BlobId blobId) {
        String blobIdString = blobId.toString();
        return Long.valueOf(blobIdString.substring(blobIdString.lastIndexOf(47) + 1));
    }

    private static int compareBlobIds(BlobId blobId1, BlobId blobId2) {
        return Upload.timestamp(blobId1).compareTo(Upload.timestamp(blobId2));
    }

    private static String blobPath(String uuid) {
        return String.format("%s/%s", "nexus-repository-docker", uuid);
    }

    public String toString() {
        return "Upload{name='" + this.name + '\'' + ", uuid='" + this.uuid + ", started=" + this.started + '}';
    }
}

