/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.repository.docker.UploadManager;
import org.sonatype.nexus.repository.docker.internal.InvalidUploadRangeException;
import org.sonatype.nexus.repository.docker.internal.Upload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.scheduling.CancelableHelper;

public class UploadManagerImpl
extends ComponentSupport
implements UploadManager {
    private final Provider<BlobStore> blobStoreProvider;

    public UploadManagerImpl(Provider<BlobStore> blobStoreProvider) {
        this.blobStoreProvider = (Provider)Preconditions.checkNotNull(blobStoreProvider);
    }

    @Override
    public synchronized Upload startUpload(String name) throws IOException {
        List<Blob> blobsByName;
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        if (this.log.isTraceEnabled() && !(blobsByName = this.blobsByName(blobStore, name)).isEmpty()) {
            this.log.trace("Secondary upload started for {}. Existing uploads uuid's are: {}", (Object)name, blobsByName.stream().map(Blob::getId));
        }
        Upload upload = new Upload(blobStore, UUID.randomUUID().toString());
        upload.create(name);
        return upload;
    }

    @Override
    public Range<Long> add(String name, String uuid, Optional<Range<Long>> range, Payload payload) throws IOException, InvalidUploadRangeException {
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        Upload upload = this.ensureGetUpload(blobStore, uuid);
        if (!upload.getName().equals(name)) {
            throw new IllegalStateException(String.format("Attempting to add to upload with uuid: %s and name: %s with different name: %s", uuid, upload.getName(), name));
        }
        return upload.addBlob(range, payload);
    }

    @Override
    public Upload complete(String name, String uuid, Optional<Range<Long>> range, Payload payload) throws IOException, InvalidUploadRangeException {
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        Upload upload = this.ensureGetUpload(blobStore, uuid);
        if (!upload.getName().equals(name)) {
            throw new IllegalStateException(String.format("Attempting to complete upload with uuid: %s and name: %s with different name: %s", uuid, upload.getName(), name));
        }
        upload.addBlob(range, payload);
        return upload;
    }

    @Override
    public long offset(String name, String uuid) throws IOException {
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        Upload upload = this.ensureGetUpload(blobStore, uuid);
        if (!upload.getName().equals(name)) {
            throw new IllegalStateException(String.format("Attempting to request upload status for uuid: %s and name: %s with different name: %s", uuid, upload.getName(), name));
        }
        return Math.max(0L, upload.length() - 1L);
    }

    @Override
    public void cancel(String uuid) throws IOException {
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        Upload upload = this.ensureGetUpload(blobStore, uuid);
        upload.cleanup();
    }

    private synchronized Upload ensureGetUpload(BlobStore blobStore, String uuid) throws IOException {
        Upload upload = new Upload(blobStore, uuid);
        if (!upload.exists()) {
            throw new IllegalStateException("Missing upload with uuid: " + uuid);
        }
        return upload;
    }

    @Override
    public synchronized void purgeUploads(Duration age) {
        BlobStore blobStore = (BlobStore)this.blobStoreProvider.get();
        CancelableHelper.checkCancellation();
        blobStore.getDirectPathBlobIdStream("nexus-repository-docker").map(arg_0 -> ((BlobStore)blobStore).get(arg_0)).filter(Objects::nonNull).filter(blob -> Instant.ofEpochMilli(blob.getMetrics().getCreationTime().getMillis()).plus(age).isBefore(Instant.now())).forEach(blob -> {
            boolean bl = blobStore.delete(blob.getId(), "Docker uploads purged.");
        });
    }

    private synchronized List<Blob> blobsByName(BlobStore blobStore, String name) {
        return blobStore.getDirectPathBlobIdStream("nexus-repository-docker").filter(blobId -> UploadManagerImpl.blobIsNotDeleted(blobId, blobStore)).map(arg_0 -> ((BlobStore)blobStore).get(arg_0)).filter(Objects::nonNull).filter(blob -> name.equals(blob.getHeaders().get("docker-name"))).collect(Collectors.toList());
    }

    private static boolean blobIsNotDeleted(BlobId blobId, BlobStore blobStore) {
        Optional<BlobAttributes> blobAttributes = Optional.ofNullable(blobStore.getBlobAttributes(blobId));
        return blobAttributes.isPresent() && !blobAttributes.get().isDeleted();
    }
}

