/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.net.HttpHeaders;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlManager;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.DockerConnectorFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.security.DockerTokenManager;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.http.HttpStatus;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.ContentTypes;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.authc.NexusBasicHttpAuthenticationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class V2Handlers
extends ComponentSupport
implements GroovyObject {
    public static final String DOCKER_CONTENT_DIGEST = "Docker-Content-Digest";
    private static final String NAME_PATTERN = "[a-z0-9]+(?:[._-][a-z0-9]+)*";
    private static final int NAME_MAX_LENGTH = 256;
    private static final Object VERSION_HEADER_KEY;
    private static final Object VERSION_HEADER_VALUE;
    private static final Object DOCKER_UPLOAD_UUID_HEADER_KEY;
    private static final String HTTP_BASIC_AUTH_HEADER;
    private static final String ANONYMOUS_TOKEN_AUTH_HEADER_PATTERN = "Bearer realm=\"%s/v2/token\",service=\"%s/v2/token\"";
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private BaseUrlManager baseUrlManager;
    @Inject
    private DockerTokenManager tokenManager;
    private Closure apiVersion;
    private Closure v2ApiVersionCheck;
    private Closure postUploadRequest;
    private Closure patchUploadRequest;
    private Closure putUploadRequest;
    private Closure deleteUploadRequest;
    private Closure getUploadRequest;
    private Closure putManifest;
    private Closure getCatalog;
    private Closure getTagList;
    private Closure getBlob;
    private Closure deleteBlob;
    private Closure acceptRanges;
    private Closure getManifest;
    private Closure deleteManifest;
    private Closure contentDigest;
    private Closure assetKind;
    private Closure catchExceptions;
    private Closure tokenAuthzHandler;
    private Closure dockerHubLibraryRedirect;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public V2Handlers() {
        MetaClass metaClass;
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        _closure1 _closure110 = new _closure1((Object)this, (Object)this);
        this.apiVersion = _closure110;
        _closure2 _closure22 = new _closure2((Object)this, (Object)this);
        this.v2ApiVersionCheck = _closure22;
        _closure3 _closure32 = new _closure3((Object)this, (Object)this);
        this.postUploadRequest = _closure32;
        _closure4 _closure42 = new _closure4((Object)this, (Object)this);
        this.patchUploadRequest = _closure42;
        _closure5 _closure52 = new _closure5((Object)this, (Object)this);
        this.putUploadRequest = _closure52;
        _closure6 _closure62 = new _closure6((Object)this, (Object)this);
        this.deleteUploadRequest = _closure62;
        _closure7 _closure72 = new _closure7((Object)this, (Object)this);
        this.getUploadRequest = _closure72;
        _closure8 _closure82 = new _closure8((Object)this, (Object)this);
        this.putManifest = _closure82;
        _closure9 _closure92 = new _closure9((Object)this, (Object)this);
        this.getCatalog = _closure92;
        _closure10 _closure102 = new _closure10((Object)this, (Object)this);
        this.getTagList = _closure102;
        _closure11 _closure112 = new _closure11((Object)this, (Object)this);
        this.getBlob = _closure112;
        _closure12 _closure122 = new _closure12((Object)this, (Object)this);
        this.deleteBlob = _closure122;
        _closure13 _closure132 = new _closure13((Object)this, (Object)this);
        this.acceptRanges = _closure132;
        _closure14 _closure142 = new _closure14((Object)this, (Object)this);
        this.getManifest = _closure142;
        _closure15 _closure152 = new _closure15((Object)this, (Object)this);
        this.deleteManifest = _closure152;
        _closure16 _closure162 = new _closure16((Object)this, (Object)this);
        this.contentDigest = _closure162;
        _closure17 _closure172 = new _closure17((Object)this, (Object)this);
        this.assetKind = _closure172;
        _closure18 _closure182 = new _closure18((Object)this, (Object)this);
        this.catchExceptions = _closure182;
        _closure19 _closure192 = new _closure19((Object)this, (Object)this);
        this.tokenAuthzHandler = _closure192;
        _closure20 _closure202 = new _closure20((Object)this, (Object)this);
        this.dockerHubLibraryRedirect = _closure202;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Response basicAuthChallenge(AuthorizationException e) {
        int n;
        int n2;
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object subject = callSiteArray[0].call((Object)this.securityHelper);
        int authenticated = 0;
        authenticated = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(subject)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(subject)) ? 1 : 0) : (n = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGetProperty(subject)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(subject)) ? 1 : 0);
        Object response = null;
        if (authenticated != 0) {
            Object object;
            response = object = callSiteArray[5].callStatic(V2Handlers.class, callSiteArray[6].call(Status.class, callSiteArray[7].callGetProperty(HttpStatus.class), callSiteArray[8].callGetProperty((Object)e)));
        } else {
            Object object;
            response = object = callSiteArray[9].callStatic(V2Handlers.class, callSiteArray[10].call(Status.class, callSiteArray[11].callGetProperty(HttpStatus.class), callSiteArray[12].callGetProperty((Object)e)));
            callSiteArray[13].call(callSiteArray[14].callGetProperty(response), callSiteArray[15].callGetProperty(HttpHeaders.class), (Object)HTTP_BASIC_AUTH_HEADER);
        }
        return (Response)ScriptBytecodeAdapter.castToType((Object)response, Response.class);
    }

    public Response tokenAuthzChallenge(Context context) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object url = callSiteArray[16].call((Object)this.baseUrlManager);
        Object urlParts = callSiteArray[17].call(url, (Object)"/");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[18].call(urlParts, (Object)0), callSiteArray[19].call(urlParts, (Object)2)}, new String[]{"", "//", ""});
        url = gStringImpl;
        String tokenHeader = ShortTypeHandling.castToString((Object)callSiteArray[20].call(String.class, (Object)ANONYMOUS_TOKEN_AUTH_HEADER_PATTERN, url, url, callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty((Object)context))));
        Object response = callSiteArray[23].callStatic(V2Handlers.class, callSiteArray[24].call(Status.class, callSiteArray[25].callGetProperty(HttpStatus.class)));
        callSiteArray[26].call(callSiteArray[27].callGetProperty(response), callSiteArray[28].callGetProperty(HttpHeaders.class), (Object)tokenHeader);
        return (Response)ScriptBytecodeAdapter.castToType((Object)response, Response.class);
    }

    public static Response toResponse(Status status) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callStatic(V2Handlers.class, (Object)status, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[30].call(V2Error.class, (Object)status)})), Response.class);
    }

    public static Response toResponse(Status status, List<V2Error> errors) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object payload = callSiteArray[31].callConstructor(StringPayload.class, callSiteArray[32].call(callSiteArray[33].callGetProperty(DockerFacetUtils.class), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"errors", errors})), callSiteArray[34].callGetProperty(ContentTypes.class));
        return (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].callConstructor(Response.Builder.class), (Object)status), payload)), Response.class);
    }

    public static Response uploadProgress(Response response, String name, String uuid, long rangeStart, long rangeEnd) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        callSiteArray[39].call(callSiteArray[40].callGetProperty((Object)response), callSiteArray[41].callGetProperty(HttpHeaders.class), (Object)new GStringImpl(new Object[]{name, uuid}, new String[]{"/v2/", "/blobs/uploads/", ""}));
        callSiteArray[42].call(callSiteArray[43].callGetProperty((Object)response), callSiteArray[44].callGetProperty(HttpHeaders.class), (Object)new GStringImpl(new Object[]{rangeStart, rangeEnd}, new String[]{"", "-", ""}));
        callSiteArray[45].call(callSiteArray[46].callGetProperty((Object)response), DOCKER_UPLOAD_UUID_HEADER_KEY, (Object)uuid);
        callSiteArray[47].call(callSiteArray[48].callGetProperty((Object)response), callSiteArray[49].callGetProperty(HttpHeaders.class), (Object)"0");
        return response;
    }

    public static Response uploadCompletion(UploadCompletion upload) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call(HttpResponses.class), Response.class);
        callSiteArray[51].call(callSiteArray[52].callGetProperty((Object)response), callSiteArray[53].callGetProperty(HttpHeaders.class), callSiteArray[54].callGetProperty((Object)upload));
        callSiteArray[55].call(callSiteArray[56].callGetProperty((Object)response), (Object)DOCKER_CONTENT_DIGEST, callSiteArray[57].callGetProperty((Object)upload));
        callSiteArray[58].call(callSiteArray[59].callGetProperty((Object)response), callSiteArray[60].callGetProperty(HttpHeaders.class), callSiteArray[61].callGetProperty((Object)upload));
        return response;
    }

    public static List extractRequiredForBlobUpload(Context context) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object state = callSiteArray[62].call(callSiteArray[63].callGetProperty((Object)context), TokenMatcher.State.class);
        Object repository = callSiteArray[64].callGetProperty((Object)context);
        String name = ShortTypeHandling.castToString((Object)callSiteArray[65].callStatic(V2Handlers.class, state));
        String uuid = ShortTypeHandling.castToString((Object)callSiteArray[66].callStatic(V2Handlers.class, state));
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{repository, name, uuid});
    }

    public static String requireName(TokenMatcher.State state, boolean validate) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Reference name = new Reference(callSiteArray[67].callStatic(V2Handlers.class, (Object)state, (Object)"name"));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (validate || ScriptBytecodeAdapter.compareNotEqual((Object)name.get(), (Object)"-")) {
                String[] pathElements = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call(name.get(), (Object)"/"), String[].class);
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[69].call(name.get()), (Object)NAME_MAX_LENGTH)) {
                    throw (Throwable)callSiteArray[70].callConstructor(V2Exception.NameInvalid.class, name.get(), (Object)new GStringImpl(new Object[]{NAME_MAX_LENGTH}, new String[]{"name to long (maximum ", " allowed)"}));
                }
                callSiteArray[71].call((Object)pathElements, (Object)new GeneratedClosure(V2Handlers.class, V2Handlers.class, name){
                    private /* synthetic */ Reference name;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _requireName_closure21.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.name = reference = name;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _requireName_closure21.$getCallSiteArray();
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it, callSiteArray[1].callGetProperty(V2Handlers.class)))) {
                            throw (Throwable)callSiteArray[2].callConstructor(V2Exception.NameInvalid.class, this.name.get(), (Object)new GStringImpl(new Object[]{it}, new String[]{"invalid path component: ", ""}));
                        }
                        return null;
                    }

                    public Object getName() {
                        CallSite[] callSiteArray = _requireName_closure21.$getCallSiteArray();
                        return this.name.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _requireName_closure21.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _requireName_closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "matches";
                        stringArray[1] = "NAME_PATTERN";
                        stringArray[2] = "<$constructor$>";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _requireName_closure21.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_requireName_closure21.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _requireName_closure21.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }
        } else if (validate || ScriptBytecodeAdapter.compareNotEqual((Object)name.get(), (Object)"-")) {
            String[] pathElements = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].call(name.get(), (Object)"/"), String[].class);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[73].call(name.get()), (Object)NAME_MAX_LENGTH)) {
                throw (Throwable)callSiteArray[74].callConstructor(V2Exception.NameInvalid.class, name.get(), (Object)new GStringImpl(new Object[]{NAME_MAX_LENGTH}, new String[]{"name to long (maximum ", " allowed)"}));
            }
            callSiteArray[75].call((Object)pathElements, (Object)new /* invalid duplicate definition of identical inner class */);
        }
        return ShortTypeHandling.castToString((Object)name.get());
    }

    public static String tag(TokenMatcher.State state) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[76].call(callSiteArray[77].callGetPropertySafe((Object)state), (Object)"tag"));
    }

    public static DockerDigest requireDigest(TokenMatcher.State state) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        String alg = ShortTypeHandling.castToString((Object)callSiteArray[78].callStatic(V2Handlers.class, (Object)state, (Object)"digestAlg"));
        String hex = ShortTypeHandling.castToString((Object)callSiteArray[79].callStatic(V2Handlers.class, (Object)state, (Object)"digestHex"));
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callConstructor(DockerDigest.class, (Object)alg, (Object)hex), DockerDigest.class);
    }

    public static String requireUUID(TokenMatcher.State state) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[81].callStatic(V2Handlers.class, (Object)state, (Object)"uuid"));
    }

    public static String requireState(TokenMatcher.State state, String key) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object value = callSiteArray[82].call(callSiteArray[83].callGetPropertySafe((Object)state), (Object)key);
        callSiteArray[84].callStatic(Preconditions.class, value);
        return ShortTypeHandling.castToString((Object)value);
    }

    public static DockerDigest requireDigestParameter(Request request) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        String digest = ShortTypeHandling.castToString((Object)callSiteArray[85].call(callSiteArray[86].callGetProperty((Object)request), (Object)"digest"));
        if (!DefaultTypeTransformation.booleanUnbox((Object)digest)) {
            throw (Throwable)callSiteArray[87].callConstructor(V2Exception.DigestInvalid.class, (Object)"digest missing");
        }
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].call(DockerDigest.class, (Object)digest), DockerDigest.class);
    }

    public static TokenMatcher.State matcherState(Context context) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return (TokenMatcher.State)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call(callSiteArray[90].call((Object)context), TokenMatcher.State.class), TokenMatcher.State.class);
    }

    public static Optional<Range<Long>> rangeOfRequest(Request request) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        Object headers = callSiteArray[91].callGetProperty((Object)request);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].call(headers, callSiteArray[93].callGetProperty(HttpHeaders.class)))) {
            Object range = callSiteArray[94].call(callSiteArray[95].call(headers, callSiteArray[96].callGetProperty(HttpHeaders.class)), (Object)"-");
            if (ScriptBytecodeAdapter.compareEqual((Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].callGetProperty(range)) ? 1 : 0), (Object)2) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].call(range, (Object)new GeneratedClosure(V2Handlers.class, V2Handlers.class){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _rangeOfRequest_closure22.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _rangeOfRequest_closure22.$getCallSiteArray();
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _rangeOfRequest_closure22.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _rangeOfRequest_closure22.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "trim";
                    return new CallSiteArray(_rangeOfRequest_closure22.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _rangeOfRequest_closure22.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }))) {
                throw (Throwable)callSiteArray[99].callConstructor(V2Exception.RangeInvalid.class, (Object)"Expected format is <start of range>-<end of range, inclusive>");
            }
            return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call(Optional.class, callSiteArray[101].call(Range.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)ScriptBytecodeAdapter.asType((Object)callSiteArray[102].call(range, (Object)0), Long.class)), Long.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)ScriptBytecodeAdapter.asType((Object)callSiteArray[103].call(range, (Object)1), Long.class)), Long.class))), Optional.class);
        }
        return (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].call(Optional.class), Optional.class);
    }

    public static V2Manifest.SchemaVersion detectClientSchemaVersionPreference(Context context) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        List acceptValues = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(callSiteArray[106].callGetProperty(callSiteArray[107].callGetProperty((Object)context)), (Object)"Accept"), List.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)acceptValues, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[108].call((Object)acceptValues, (Object)new GeneratedClosure(V2Handlers.class, V2Handlers.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            private static /* synthetic */ Class $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes;
            {
                CallSite[] callSiteArray = _detectClientSchemaVersionPreference_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _detectClientSchemaVersionPreference_closure23.$getCallSiteArray();
                return callSiteArray[0].call(it, callSiteArray[1].callGetProperty((Object)_detectClientSchemaVersionPreference_closure23.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _detectClientSchemaVersionPreference_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _detectClientSchemaVersionPreference_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "V2_MANIFEST_SCHEMA_2";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _detectClientSchemaVersionPreference_closure23.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_detectClientSchemaVersionPreference_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _detectClientSchemaVersionPreference_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            private static /* synthetic */ Class $get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes() {
                Class clazz = $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes;
                if (clazz == null) {
                    clazz = $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes = _detectClientSchemaVersionPreference_closure23.class$("org.sonatype.nexus.repository.docker.internal.V2ContentTypes");
                }
                return clazz;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }))) {
            return (V2Manifest.SchemaVersion)ShortTypeHandling.castToEnum((Object)callSiteArray[109].callGetProperty(V2Manifest.SchemaVersion.class), V2Manifest.SchemaVersion.class);
        }
        return (V2Manifest.SchemaVersion)ShortTypeHandling.castToEnum((Object)callSiteArray[110].callGetProperty(V2Manifest.SchemaVersion.class), V2Manifest.SchemaVersion.class);
    }

    public static Response uploadProgress(Response response, String name, String uuid, long rangeStart) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return V2Handlers.uploadProgress(response, name, uuid, rangeStart, 0);
    }

    public static Response uploadProgress(Response response, String name, String uuid) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return V2Handlers.uploadProgress(response, name, uuid, 0, 0);
    }

    public static String requireName(TokenMatcher.State state) {
        CallSite[] callSiteArray = V2Handlers.$getCallSiteArray();
        return V2Handlers.requireName(state, true);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != V2Handlers.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string = "Docker-Upload-UUID";
        DOCKER_UPLOAD_UUID_HEADER_KEY = string;
        String string2 = "registry/2.0";
        VERSION_HEADER_VALUE = string2;
        String string3 = "Docker-Distribution-Api-Version";
        VERSION_HEADER_KEY = string3;
        GStringImpl gStringImpl = new GStringImpl(new Object[]{V2Handlers.$getCallSiteArray()[111].callGetProperty(NexusBasicHttpAuthenticationFilter.class)}, new String[]{"BASIC realm=\"", "\""});
        HTTP_BASIC_AUTH_HEADER = ShortTypeHandling.castToString((Object)gStringImpl);
    }

    public static final String getNAME_PATTERN() {
        return NAME_PATTERN;
    }

    public static final int getNAME_MAX_LENGTH() {
        return NAME_MAX_LENGTH;
    }

    public static final Object getVERSION_HEADER_KEY() {
        return VERSION_HEADER_KEY;
    }

    public static final Object getVERSION_HEADER_VALUE() {
        return VERSION_HEADER_VALUE;
    }

    public static final Object getDOCKER_UPLOAD_UUID_HEADER_KEY() {
        return DOCKER_UPLOAD_UUID_HEADER_KEY;
    }

    public static final String getHTTP_BASIC_AUTH_HEADER() {
        return HTTP_BASIC_AUTH_HEADER;
    }

    public static final String getANONYMOUS_TOKEN_AUTH_HEADER_PATTERN() {
        return ANONYMOUS_TOKEN_AUTH_HEADER_PATTERN;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public BaseUrlManager getBaseUrlManager() {
        return this.baseUrlManager;
    }

    public void setBaseUrlManager(BaseUrlManager baseUrlManager) {
        this.baseUrlManager = baseUrlManager;
    }

    public DockerTokenManager getTokenManager() {
        return this.tokenManager;
    }

    public void setTokenManager(DockerTokenManager dockerTokenManager) {
        this.tokenManager = dockerTokenManager;
    }

    public Closure getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(Closure closure) {
        this.apiVersion = closure;
    }

    public Closure getV2ApiVersionCheck() {
        return this.v2ApiVersionCheck;
    }

    public void setV2ApiVersionCheck(Closure closure) {
        this.v2ApiVersionCheck = closure;
    }

    public Closure getPostUploadRequest() {
        return this.postUploadRequest;
    }

    public void setPostUploadRequest(Closure closure) {
        this.postUploadRequest = closure;
    }

    public Closure getPatchUploadRequest() {
        return this.patchUploadRequest;
    }

    public void setPatchUploadRequest(Closure closure) {
        this.patchUploadRequest = closure;
    }

    public Closure getPutUploadRequest() {
        return this.putUploadRequest;
    }

    public void setPutUploadRequest(Closure closure) {
        this.putUploadRequest = closure;
    }

    public Closure getDeleteUploadRequest() {
        return this.deleteUploadRequest;
    }

    public void setDeleteUploadRequest(Closure closure) {
        this.deleteUploadRequest = closure;
    }

    public Closure getGetUploadRequest() {
        return this.getUploadRequest;
    }

    public void setGetUploadRequest(Closure closure) {
        this.getUploadRequest = closure;
    }

    public Closure getPutManifest() {
        return this.putManifest;
    }

    public void setPutManifest(Closure closure) {
        this.putManifest = closure;
    }

    public Closure getGetCatalog() {
        return this.getCatalog;
    }

    public void setGetCatalog(Closure closure) {
        this.getCatalog = closure;
    }

    public Closure getGetTagList() {
        return this.getTagList;
    }

    public void setGetTagList(Closure closure) {
        this.getTagList = closure;
    }

    public Closure getGetBlob() {
        return this.getBlob;
    }

    public void setGetBlob(Closure closure) {
        this.getBlob = closure;
    }

    public Closure getDeleteBlob() {
        return this.deleteBlob;
    }

    public void setDeleteBlob(Closure closure) {
        this.deleteBlob = closure;
    }

    public Closure getAcceptRanges() {
        return this.acceptRanges;
    }

    public void setAcceptRanges(Closure closure) {
        this.acceptRanges = closure;
    }

    public Closure getGetManifest() {
        return this.getManifest;
    }

    public void setGetManifest(Closure closure) {
        this.getManifest = closure;
    }

    public Closure getDeleteManifest() {
        return this.deleteManifest;
    }

    public void setDeleteManifest(Closure closure) {
        this.deleteManifest = closure;
    }

    public Closure getContentDigest() {
        return this.contentDigest;
    }

    public void setContentDigest(Closure closure) {
        this.contentDigest = closure;
    }

    public Closure getAssetKind() {
        return this.assetKind;
    }

    public void setAssetKind(Closure closure) {
        this.assetKind = closure;
    }

    public Closure getCatchExceptions() {
        return this.catchExceptions;
    }

    public void setCatchExceptions(Closure closure) {
        this.catchExceptions = closure;
    }

    public Closure getTokenAuthzHandler() {
        return this.tokenAuthzHandler;
    }

    public void setTokenAuthzHandler(Closure closure) {
        this.tokenAuthzHandler = closure;
    }

    public Closure getDockerHubLibraryRedirect() {
        return this.dockerHubLibraryRedirect;
    }

    public void setDockerHubLibraryRedirect(Closure closure) {
        this.dockerHubLibraryRedirect = closure;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "subject";
        stringArray[1] = "principal";
        stringArray[2] = "authenticated";
        stringArray[3] = "principal";
        stringArray[4] = "authenticated";
        stringArray[5] = "toResponse";
        stringArray[6] = "failure";
        stringArray[7] = "FORBIDDEN";
        stringArray[8] = "message";
        stringArray[9] = "toResponse";
        stringArray[10] = "failure";
        stringArray[11] = "UNAUTHORIZED";
        stringArray[12] = "message";
        stringArray[13] = "set";
        stringArray[14] = "headers";
        stringArray[15] = "WWW_AUTHENTICATE";
        stringArray[16] = "detectUrl";
        stringArray[17] = "split";
        stringArray[18] = "getAt";
        stringArray[19] = "getAt";
        stringArray[20] = "format";
        stringArray[21] = "name";
        stringArray[22] = "repository";
        stringArray[23] = "toResponse";
        stringArray[24] = "failure";
        stringArray[25] = "UNAUTHORIZED";
        stringArray[26] = "set";
        stringArray[27] = "headers";
        stringArray[28] = "WWW_AUTHENTICATE";
        stringArray[29] = "toResponse";
        stringArray[30] = "mapFromStatus";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "writeValueAsString";
        stringArray[33] = "mapper";
        stringArray[34] = "APPLICATION_JSON";
        stringArray[35] = "build";
        stringArray[36] = "payload";
        stringArray[37] = "status";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "set";
        stringArray[40] = "headers";
        stringArray[41] = "LOCATION";
        stringArray[42] = "set";
        stringArray[43] = "headers";
        stringArray[44] = "RANGE";
        stringArray[45] = "set";
        stringArray[46] = "headers";
        stringArray[47] = "set";
        stringArray[48] = "headers";
        stringArray[49] = "CONTENT_LENGTH";
        stringArray[50] = "created";
        stringArray[51] = "set";
        stringArray[52] = "headers";
        stringArray[53] = "LOCATION";
        stringArray[54] = "location";
        stringArray[55] = "set";
        stringArray[56] = "headers";
        stringArray[57] = "digest";
        stringArray[58] = "set";
        stringArray[59] = "headers";
        stringArray[60] = "CONTENT_RANGE";
        stringArray[61] = "range";
        stringArray[62] = "require";
        stringArray[63] = "attributes";
        stringArray[64] = "repository";
        stringArray[65] = "requireName";
        stringArray[66] = "requireUUID";
        stringArray[67] = "requireState";
        stringArray[68] = "split";
        stringArray[69] = "length";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "each";
        stringArray[72] = "split";
        stringArray[73] = "length";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "each";
        stringArray[76] = "getAt";
        stringArray[77] = "tokens";
        stringArray[78] = "requireState";
        stringArray[79] = "requireState";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "requireState";
        stringArray[82] = "getAt";
        stringArray[83] = "tokens";
        stringArray[84] = "checkNotNull";
        stringArray[85] = "get";
        stringArray[86] = "parameters";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "parse";
        stringArray[89] = "require";
        stringArray[90] = "getAttributes";
        stringArray[91] = "headers";
        stringArray[92] = "contains";
        stringArray[93] = "CONTENT_RANGE";
        stringArray[94] = "split";
        stringArray[95] = "get";
        stringArray[96] = "CONTENT_RANGE";
        stringArray[97] = "length";
        stringArray[98] = "any";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "of";
        stringArray[101] = "closed";
        stringArray[102] = "getAt";
        stringArray[103] = "getAt";
        stringArray[104] = "empty";
        stringArray[105] = "getAll";
        stringArray[106] = "headers";
        stringArray[107] = "request";
        stringArray[108] = "any";
        stringArray[109] = "Schema2";
        stringArray[110] = "Schema1";
        stringArray[111] = "BASIC_AUTH_REALM";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[112];
        V2Handlers.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(V2Handlers.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = V2Handlers.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            Object response = callSiteArray[0].call((Object)context);
            callSiteArray[1].call(callSiteArray[2].callGetProperty(response), callSiteArray[3].callGetProperty(V2Handlers.class), callSiteArray[4].callGetProperty(V2Handlers.class));
            return response;
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return callSiteArray[5].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "proceed";
            stringArray[1] = "set";
            stringArray[2] = "headers";
            stringArray[3] = "VERSION_HEADER_KEY";
            stringArray[4] = "VERSION_HEADER_VALUE";
            stringArray[5] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            _closure1.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure2(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure2.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure2.$getCallSiteArray();
            Object subject = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(subject)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(AnonymousHelper.class, subject))) {
                return callSiteArray[4].call(HttpResponses.class);
            }
            throw (Throwable)callSiteArray[5].callConstructor(AuthorizationException.class);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure2.$getCallSiteArray();
            return callSiteArray[6].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "subject";
            stringArray[1] = "securityHelper";
            stringArray[2] = "authenticated";
            stringArray[3] = "isAnonymous";
            stringArray[4] = "ok";
            stringArray[5] = "<$constructor$>";
            stringArray[6] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[7];
            _closure2.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure2.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure2.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure3(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[3].callCurrent((GroovyObject)this, state));
            String uuid = ShortTypeHandling.castToString((Object)callSiteArray[4].call(callSiteArray[5].call(repository, DockerHostedFacet.class), (Object)name));
            callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)"Upload request received for repository {} and image name {}. Assigned uuid {}", callSiteArray[8].callGetProperty(repository), (Object)name, (Object)uuid);
            Object payload = callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty((Object)context));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(callSiteArray[12].callGetProperty(callSiteArray[13].callGetProperty((Object)context)), (Object)"digest")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGetProperty(payload))) {
                DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callCurrent((GroovyObject)this, callSiteArray[16].callGetProperty((Object)context)), DockerDigest.class);
                callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)"Upload request assigned uuid: {} includes all data, completing in one step with digest: {}", (Object)uuid, (Object)digest);
                return callSiteArray[19].callCurrent((GroovyObject)this, callSiteArray[20].call(callSiteArray[21].call(repository, DockerHostedFacet.class), ArrayUtil.createArray((Object)name, (Object)uuid, (Object)digest, (Object)callSiteArray[22].callCurrent((GroovyObject)this, callSiteArray[23].callGetProperty((Object)context)), (Object)payload)));
            }
            return callSiteArray[24].callCurrent((GroovyObject)this, callSiteArray[25].call(HttpResponses.class), (Object)name, (Object)uuid);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
            return callSiteArray[26].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "requireName";
            stringArray[4] = "beginBlobUpload";
            stringArray[5] = "facet";
            stringArray[6] = "debug";
            stringArray[7] = "log";
            stringArray[8] = "name";
            stringArray[9] = "payload";
            stringArray[10] = "request";
            stringArray[11] = "contains";
            stringArray[12] = "parameters";
            stringArray[13] = "request";
            stringArray[14] = "size";
            stringArray[15] = "requireDigestParameter";
            stringArray[16] = "request";
            stringArray[17] = "debug";
            stringArray[18] = "log";
            stringArray[19] = "uploadCompletion";
            stringArray[20] = "completeBlobUpload";
            stringArray[21] = "facet";
            stringArray[22] = "rangeOfRequest";
            stringArray[23] = "request";
            stringArray[24] = "uploadProgress";
            stringArray[25] = "accepted";
            stringArray[26] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[27];
            _closure3.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure3.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure3.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure4(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
            Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)context);
            Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(object, (Object)0), Repository.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[2].call(object, (Object)1));
            String uuid = ShortTypeHandling.castToString((Object)callSiteArray[3].call(object, (Object)2));
            callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Patch request received for repository {} and image name {} and uuid {}", callSiteArray[6].callGetProperty((Object)repository), (Object)name, (Object)uuid);
            Range uploadRange = (Range)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call(callSiteArray[8].call((Object)repository, DockerHostedFacet.class), (Object)name, (Object)uuid, callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].callGetProperty((Object)context)), callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty((Object)context))), Range.class);
            return callSiteArray[13].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[14].call(HttpResponses.class), (Object)name, (Object)uuid, (Object)0, (Object)callSiteArray[15].call((Object)uploadRange)));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
            return callSiteArray[16].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "extractRequiredForBlobUpload";
            stringArray[1] = "getAt";
            stringArray[2] = "getAt";
            stringArray[3] = "getAt";
            stringArray[4] = "debug";
            stringArray[5] = "log";
            stringArray[6] = "name";
            stringArray[7] = "uploadBlobRange";
            stringArray[8] = "facet";
            stringArray[9] = "rangeOfRequest";
            stringArray[10] = "request";
            stringArray[11] = "payload";
            stringArray[12] = "request";
            stringArray[13] = "uploadProgress";
            stringArray[14] = "accepted";
            stringArray[15] = "upperEndpoint";
            stringArray[16] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[17];
            _closure4.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure4.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure4.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure5
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure5(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
            Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)context);
            Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(object, (Object)0), Repository.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[2].call(object, (Object)1));
            String uuid = ShortTypeHandling.castToString((Object)callSiteArray[3].call(object, (Object)2));
            callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Upload request completion for repository: {}, image name: {} and uuid: {}", callSiteArray[6].callGetProperty((Object)repository), (Object)name, (Object)uuid);
            callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)"Upload params: {}", callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty((Object)context)));
            UploadCompletion upload = (UploadCompletion)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].call((Object)repository, DockerHostedFacet.class), ArrayUtil.createArray((Object)name, (Object)uuid, (Object)callSiteArray[13].callCurrent((GroovyObject)this, callSiteArray[14].callGetProperty((Object)context)), (Object)callSiteArray[15].callCurrent((GroovyObject)this, callSiteArray[16].callGetProperty((Object)context)), (Object)callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty((Object)context)))), UploadCompletion.class);
            return callSiteArray[19].callCurrent((GroovyObject)this, (Object)upload);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
            return callSiteArray[20].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure5.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "extractRequiredForBlobUpload";
            stringArray[1] = "getAt";
            stringArray[2] = "getAt";
            stringArray[3] = "getAt";
            stringArray[4] = "debug";
            stringArray[5] = "log";
            stringArray[6] = "name";
            stringArray[7] = "debug";
            stringArray[8] = "log";
            stringArray[9] = "parameters";
            stringArray[10] = "request";
            stringArray[11] = "completeBlobUpload";
            stringArray[12] = "facet";
            stringArray[13] = "requireDigestParameter";
            stringArray[14] = "request";
            stringArray[15] = "rangeOfRequest";
            stringArray[16] = "request";
            stringArray[17] = "payload";
            stringArray[18] = "request";
            stringArray[19] = "uploadCompletion";
            stringArray[20] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[21];
            _closure5.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure5.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure5.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure6
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure6(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure6.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure6.$getCallSiteArray();
            Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)context);
            Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(object, (Object)0), Repository.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[2].call(object, (Object)1));
            String uuid = ShortTypeHandling.castToString((Object)callSiteArray[3].call(object, (Object)2));
            callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Upload delete request for repository: {}, image name: {} and uuid: {}", callSiteArray[6].callGetProperty((Object)repository), (Object)name, (Object)uuid);
            callSiteArray[7].call(callSiteArray[8].call((Object)repository, DockerHostedFacet.class), (Object)name, (Object)uuid);
            return callSiteArray[9].call(HttpResponses.class);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure6.$getCallSiteArray();
            return callSiteArray[10].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure6.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "extractRequiredForBlobUpload";
            stringArray[1] = "getAt";
            stringArray[2] = "getAt";
            stringArray[3] = "getAt";
            stringArray[4] = "debug";
            stringArray[5] = "log";
            stringArray[6] = "name";
            stringArray[7] = "deleteUpload";
            stringArray[8] = "facet";
            stringArray[9] = "noContent";
            stringArray[10] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[11];
            _closure6.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure6.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure6.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure7
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure7(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
            Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)context);
            Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(object, (Object)0), Repository.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[2].call(object, (Object)1));
            String uuid = ShortTypeHandling.castToString((Object)callSiteArray[3].call(object, (Object)2));
            callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Upload request confirmation for repository: {}, image name: {} and uuid: {}", callSiteArray[6].callGetProperty((Object)repository), (Object)name, (Object)uuid);
            long offset = DefaultTypeTransformation.longUnbox((Object)callSiteArray[7].call(callSiteArray[8].call((Object)repository, DockerHostedFacet.class), (Object)name, (Object)uuid));
            return callSiteArray[9].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[10].call(HttpResponses.class), (Object)name, (Object)uuid, (Object)0, (Object)offset));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
            return callSiteArray[11].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure7.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "extractRequiredForBlobUpload";
            stringArray[1] = "getAt";
            stringArray[2] = "getAt";
            stringArray[3] = "getAt";
            stringArray[4] = "debug";
            stringArray[5] = "log";
            stringArray[6] = "name";
            stringArray[7] = "getBlobUploadProgress";
            stringArray[8] = "facet";
            stringArray[9] = "uploadProgress";
            stringArray[10] = "noContent";
            stringArray[11] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[12];
            _closure7.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure7.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure7.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure8
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure8(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            DockerHostedFacet dockerHostedFacet = (DockerHostedFacet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(repository, DockerHostedFacet.class), DockerHostedFacet.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[4].callCurrent((GroovyObject)this, state));
            String tag = ShortTypeHandling.castToString((Object)callSiteArray[5].callCurrent((GroovyObject)this, state));
            Content content = null;
            if (DefaultTypeTransformation.booleanUnbox((Object)tag)) {
                callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)"Upload request for manifest to repository: {} for tag {}/{}", callSiteArray[8].callGetProperty(repository), (Object)name, (Object)tag);
                Object object = callSiteArray[9].call((Object)dockerHostedFacet, (Object)name, (Object)tag, callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)context)));
                content = (Content)ScriptBytecodeAdapter.castToType((Object)object, Content.class);
            } else {
                DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, state), DockerDigest.class);
                callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), (Object)"Upload request for manifest to repository: {} for digest {}/{}", callSiteArray[15].callGetProperty(repository), (Object)name, (Object)digest);
                Object object = callSiteArray[16].call((Object)dockerHostedFacet, (Object)name, (Object)digest, callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty((Object)context)));
                content = (Content)ScriptBytecodeAdapter.castToType((Object)object, Content.class);
            }
            return callSiteArray[19].call(HttpResponses.class, (Object)content);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
            return callSiteArray[20].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure8.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "facet";
            stringArray[4] = "requireName";
            stringArray[5] = "tag";
            stringArray[6] = "debug";
            stringArray[7] = "log";
            stringArray[8] = "name";
            stringArray[9] = "putManifestByTag";
            stringArray[10] = "payload";
            stringArray[11] = "request";
            stringArray[12] = "requireDigest";
            stringArray[13] = "debug";
            stringArray[14] = "log";
            stringArray[15] = "name";
            stringArray[16] = "putManifestByDigest";
            stringArray[17] = "payload";
            stringArray[18] = "request";
            stringArray[19] = "created";
            stringArray[20] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[21];
            _closure8.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure8.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure8.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure9
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure9(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
            return callSiteArray[0].call(HttpResponses.class, callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGetProperty((Object)context), DockerHostedFacet.class)));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
            return callSiteArray[4].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure9.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "ok";
            stringArray[1] = "getCatalog";
            stringArray[2] = "facet";
            stringArray[3] = "repository";
            stringArray[4] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[5];
            _closure9.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure9.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure9.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure10
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure10(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            return callSiteArray[3].call(HttpResponses.class, callSiteArray[4].call(callSiteArray[5].call(repository, DockerHostedFacet.class), callSiteArray[6].callCurrent((GroovyObject)this, state)));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
            return callSiteArray[7].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure10.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "ok";
            stringArray[4] = "getTagList";
            stringArray[5] = "facet";
            stringArray[6] = "requireName";
            stringArray[7] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            _closure10.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure10.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure10.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure11
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure11(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            return callSiteArray[3].call(HttpResponses.class, callSiteArray[4].call(callSiteArray[5].call(repository, DockerHostedFacet.class), callSiteArray[6].callCurrent((GroovyObject)this, state)));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
            return callSiteArray[7].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure11.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "ok";
            stringArray[4] = "getBlob";
            stringArray[5] = "facet";
            stringArray[6] = "requireDigest";
            stringArray[7] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            _closure11.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure11.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure11.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure12
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure12(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            callSiteArray[3].call(callSiteArray[4].call(repository, DockerHostedFacet.class), callSiteArray[5].callCurrent((GroovyObject)this, state));
            return callSiteArray[6].call(HttpResponses.class);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
            return callSiteArray[7].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure12.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "deleteBlob";
            stringArray[4] = "facet";
            stringArray[5] = "requireDigest";
            stringArray[6] = "accepted";
            stringArray[7] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            _closure12.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure12.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure12.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure13
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure13(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
            Object response = callSiteArray[0].call((Object)context);
            callSiteArray[1].call(callSiteArray[2].callGetProperty(response), callSiteArray[3].callGetProperty(org.apache.http.HttpHeaders.class), (Object)"bytes");
            return response;
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
            return callSiteArray[4].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure13.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "proceed";
            stringArray[1] = "set";
            stringArray[2] = "headers";
            stringArray[3] = "ACCEPT_RANGES";
            stringArray[4] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[5];
            _closure13.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure13.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure13.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure14
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure14(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            DockerHostedFacet dockerHostedFacet = (DockerHostedFacet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(repository, DockerHostedFacet.class), DockerHostedFacet.class);
            String name = ShortTypeHandling.castToString((Object)callSiteArray[4].callCurrent((GroovyObject)this, state));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callCurrent((GroovyObject)this, state))) {
                V2Manifest.SchemaVersion schemaVersion = (V2Manifest.SchemaVersion)ShortTypeHandling.castToEnum((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)context), V2Manifest.SchemaVersion.class);
                return callSiteArray[7].call(HttpResponses.class, callSiteArray[8].call((Object)dockerHostedFacet, (Object)name, callSiteArray[9].callCurrent((GroovyObject)this, state), (Object)schemaVersion));
            }
            return callSiteArray[10].call(HttpResponses.class, callSiteArray[11].call((Object)dockerHostedFacet, (Object)name, callSiteArray[12].callCurrent((GroovyObject)this, state)));
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
            return callSiteArray[13].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure14.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "facet";
            stringArray[4] = "requireName";
            stringArray[5] = "tag";
            stringArray[6] = "detectClientSchemaVersionPreference";
            stringArray[7] = "ok";
            stringArray[8] = "getManifestByTag";
            stringArray[9] = "tag";
            stringArray[10] = "ok";
            stringArray[11] = "getManifestByDigest";
            stringArray[12] = "requireDigest";
            stringArray[13] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[14];
            _closure14.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure14.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure14.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure15
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure15(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure15.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure15.$getCallSiteArray();
            Object state = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), TokenMatcher.State.class);
            Object repository = callSiteArray[2].callGetProperty((Object)context);
            callSiteArray[3].call(callSiteArray[4].call(repository, DockerHostedFacet.class), callSiteArray[5].callCurrent((GroovyObject)this, state), callSiteArray[6].callCurrent((GroovyObject)this, state));
            return callSiteArray[7].call(HttpResponses.class);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure15.$getCallSiteArray();
            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure15.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "require";
            stringArray[1] = "attributes";
            stringArray[2] = "repository";
            stringArray[3] = "deleteManifest";
            stringArray[4] = "facet";
            stringArray[5] = "requireName";
            stringArray[6] = "requireDigest";
            stringArray[7] = "accepted";
            stringArray[8] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[9];
            _closure15.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure15.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure15.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure16
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure16(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
            Object response = callSiteArray[0].call((Object)context);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(callSiteArray[2].callGetProperty(response), callSiteArray[3].callGetProperty(V2Handlers.class))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(response)) && callSiteArray[5].callGetProperty(response) instanceof Content) {
                Object contentDigest = callSiteArray[6].call(callSiteArray[7].callGetProperty((Object)((Content)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callGetProperty(response), Content.class))), callSiteArray[9].callGetProperty(V2Handlers.class), String.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)contentDigest)) {
                    callSiteArray[10].call(callSiteArray[11].callGetProperty(response), callSiteArray[12].callGetProperty(V2Handlers.class), contentDigest);
                }
            }
            return response;
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
            return callSiteArray[13].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure16.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "proceed";
            stringArray[1] = "contains";
            stringArray[2] = "headers";
            stringArray[3] = "DOCKER_CONTENT_DIGEST";
            stringArray[4] = "payload";
            stringArray[5] = "payload";
            stringArray[6] = "get";
            stringArray[7] = "attributes";
            stringArray[8] = "payload";
            stringArray[9] = "DOCKER_CONTENT_DIGEST";
            stringArray[10] = "set";
            stringArray[11] = "headers";
            stringArray[12] = "DOCKER_CONTENT_DIGEST";
            stringArray[13] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[14];
            _closure16.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure16.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure16.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure17
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;
        private static /* synthetic */ Class $class$org$sonatype$nexus$repository$docker$internal$AssetKind;

        public _closure17(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context, AssetKind value) {
            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
            callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)context), (Object)_closure17.$get$$class$org$sonatype$nexus$repository$docker$internal$AssetKind(), (Object)value);
            return callSiteArray[2].call((Object)context);
        }

        public Object call(Context context, AssetKind value) {
            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
            return callSiteArray[3].callCurrent((GroovyObject)this, (Object)context, (Object)value);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure17.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "set";
            stringArray[1] = "attributes";
            stringArray[2] = "proceed";
            stringArray[3] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            _closure17.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure17.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure17.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        private static /* synthetic */ Class $get$$class$org$sonatype$nexus$repository$docker$internal$AssetKind() {
            Class clazz = $class$org$sonatype$nexus$repository$docker$internal$AssetKind;
            if (clazz == null) {
                clazz = $class$org$sonatype$nexus$repository$docker$internal$AssetKind = _closure17.class$("org.sonatype.nexus.repository.docker.internal.AssetKind");
            }
            return clazz;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class _closure18
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure18(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure18.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            Object response;
            block16: {
                CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                response = null;
                try {
                    Object object;
                    response = object = callSiteArray[0].call((Object)context);
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(response))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGetProperty(response))) {
                            Object object2;
                            response = object2 = callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callConstructor(Response.Builder.class), response), callSiteArray[8].callGetProperty(callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].callGetProperty(response)))));
                        }
                    } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(response))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGetProperty(response))) {
                        Object object3;
                        response = object3 = callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].callConstructor(Response.Builder.class), response), callSiteArray[18].callGetProperty(callSiteArray[19].callCurrent((GroovyObject)this, callSiteArray[20].callGetProperty(response)))));
                    }
                }
                catch (V2Exception e) {
                    Object object;
                    Optional proxy = (Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(callSiteArray[22].callGetProperty((Object)context), ProxyFacet.class), Optional.class);
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[23].call((Object)e), (Object)callSiteArray[24].callGetProperty(HttpStatus.class))) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)proxy))) {
                            String host = ShortTypeHandling.castToString((Object)callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call((Object)proxy))));
                            callSiteArray[29].call(callSiteArray[30].callGroovyObjectGetProperty((Object)this), callSiteArray[31].call((Object)"Is the remote url a valid docker endpoint? Remote host {} with path {} did not return the ", (Object)"expected response. Error message: {}"), (Object)host, callSiteArray[32].callGetProperty(callSiteArray[33].call((Object)context)), callSiteArray[34].call((Object)e));
                        }
                    } else {
                        callSiteArray[35].call(callSiteArray[36].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Error: {} {}: {} - {}", (Object)callSiteArray[37].callGetProperty(callSiteArray[38].callGetProperty((Object)context)), (Object)callSiteArray[39].callGetProperty(callSiteArray[40].callGetProperty((Object)context)), (Object)callSiteArray[41].callGetProperty((Object)e), (Object)callSiteArray[42].call((Object)e)));
                    }
                    Object code = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[43].call((Object)e), (Object)callSiteArray[44].callGetProperty(HttpStatus.class)) ? callSiteArray[45].callGetProperty(HttpStatus.class) : callSiteArray[46].call((Object)e);
                    response = object = callSiteArray[47].callCurrent((GroovyObject)this, callSiteArray[48].call(Status.class, code), callSiteArray[49].callGetProperty((Object)e));
                }
                catch (AuthorizationException e) {
                    Object object;
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].callGetProperty((Object)context), DockerConnectorFacet.class)))) {
                        Object object4;
                        response = object4 = callSiteArray[53].callCurrent((GroovyObject)this, (Object)e);
                        break block16;
                    }
                    response = object = callSiteArray[54].callCurrent((GroovyObject)this, (Object)context);
                }
                catch (IllegalOperationException e) {
                    Object object;
                    callSiteArray[55].call(callSiteArray[56].callGroovyObjectGetProperty((Object)this), (Object)"Error: {} {}: 400 - {}", callSiteArray[57].callGetProperty(callSiteArray[58].callGetProperty((Object)context)), callSiteArray[59].callGetProperty(callSiteArray[60].callGetProperty((Object)context)), callSiteArray[61].callGetProperty((Object)e));
                    response = object = callSiteArray[62].callCurrent((GroovyObject)this, callSiteArray[63].call(Status.class, callSiteArray[64].callGetProperty(HttpStatus.class)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[65].call(callSiteArray[66].callGetProperty(V2Error.class), callSiteArray[67].callGetProperty((Object)e))}));
                }
                catch (InvalidContentException e) {
                    Object object;
                    callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty((Object)this), (Object)"Error: {} {}: 400 - {}", callSiteArray[70].callGetProperty(callSiteArray[71].callGetProperty((Object)context)), callSiteArray[72].callGetProperty(callSiteArray[73].callGetProperty((Object)context)), callSiteArray[74].callGetProperty((Object)e));
                    response = object = callSiteArray[75].callCurrent((GroovyObject)this, callSiteArray[76].call(Status.class, callSiteArray[77].callGetProperty(HttpStatus.class)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[78].call(callSiteArray[79].callGetProperty(V2Error.class), callSiteArray[80].callGetProperty((Object)e))}));
                }
                catch (Exception e) {
                    Object object;
                    callSiteArray[81].call(callSiteArray[82].callGroovyObjectGetProperty((Object)this), (Object)"Error: {} {}", callSiteArray[83].callGetProperty(callSiteArray[84].callGetProperty((Object)context)), callSiteArray[85].callGetProperty(callSiteArray[86].callGetProperty((Object)context)), (Object)e);
                    response = object = callSiteArray[87].callCurrent((GroovyObject)this, callSiteArray[88].call(Status.class, callSiteArray[89].callGetProperty(HttpStatus.class)));
                }
            }
            return response;
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure18.$getCallSiteArray();
            return callSiteArray[90].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure18.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "proceed";
            stringArray[1] = "successful";
            stringArray[2] = "status";
            stringArray[3] = "payload";
            stringArray[4] = "build";
            stringArray[5] = "payload";
            stringArray[6] = "copy";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "payload";
            stringArray[9] = "toResponse";
            stringArray[10] = "status";
            stringArray[11] = "successful";
            stringArray[12] = "status";
            stringArray[13] = "payload";
            stringArray[14] = "build";
            stringArray[15] = "payload";
            stringArray[16] = "copy";
            stringArray[17] = "<$constructor$>";
            stringArray[18] = "payload";
            stringArray[19] = "toResponse";
            stringArray[20] = "status";
            stringArray[21] = "optionalFacet";
            stringArray[22] = "repository";
            stringArray[23] = "getHttpCode";
            stringArray[24] = "NOT_FOUND";
            stringArray[25] = "isPresent";
            stringArray[26] = "toString";
            stringArray[27] = "getRemoteUrl";
            stringArray[28] = "get";
            stringArray[29] = "warn";
            stringArray[30] = "log";
            stringArray[31] = "plus";
            stringArray[32] = "path";
            stringArray[33] = "getRequest";
            stringArray[34] = "getMessage";
            stringArray[35] = "warn";
            stringArray[36] = "log";
            stringArray[37] = "action";
            stringArray[38] = "request";
            stringArray[39] = "path";
            stringArray[40] = "request";
            stringArray[41] = "httpCode";
            stringArray[42] = "toString";
            stringArray[43] = "getHttpCode";
            stringArray[44] = "UNAUTHORIZED";
            stringArray[45] = "BAD_GATEWAY";
            stringArray[46] = "getHttpCode";
            stringArray[47] = "toResponse";
            stringArray[48] = "failure";
            stringArray[49] = "errors";
            stringArray[50] = "isForceBasicAuth";
            stringArray[51] = "facet";
            stringArray[52] = "repository";
            stringArray[53] = "basicAuthChallenge";
            stringArray[54] = "tokenAuthzChallenge";
            stringArray[55] = "warn";
            stringArray[56] = "log";
            stringArray[57] = "action";
            stringArray[58] = "request";
            stringArray[59] = "path";
            stringArray[60] = "request";
            stringArray[61] = "message";
            stringArray[62] = "toResponse";
            stringArray[63] = "failure";
            stringArray[64] = "BAD_REQUEST";
            stringArray[65] = "withDetail";
            stringArray[66] = "BLOB_UPLOAD_INVALID";
            stringArray[67] = "message";
            stringArray[68] = "warn";
            stringArray[69] = "log";
            stringArray[70] = "action";
            stringArray[71] = "request";
            stringArray[72] = "path";
            stringArray[73] = "request";
            stringArray[74] = "message";
            stringArray[75] = "toResponse";
            stringArray[76] = "failure";
            stringArray[77] = "BAD_REQUEST";
            stringArray[78] = "withDetail";
            stringArray[79] = "BLOB_UPLOAD_INVALID";
            stringArray[80] = "message";
            stringArray[81] = "warn";
            stringArray[82] = "log";
            stringArray[83] = "action";
            stringArray[84] = "request";
            stringArray[85] = "path";
            stringArray[86] = "request";
            stringArray[87] = "toResponse";
            stringArray[88] = "failure";
            stringArray[89] = "INTERNAL_SERVER_ERROR";
            stringArray[90] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[91];
            _closure18.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure18.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure18.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure19
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure19(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
            Response response = null;
            Object token = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)token, null)) {
                StringPayload payload = (StringPayload)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(StringPayload.class, callSiteArray[3].call(callSiteArray[4].callGetProperty(DockerFacetUtils.class), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"token", token})), callSiteArray[5].callGetProperty(ContentTypes.class)), StringPayload.class);
                Object object = callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callConstructor(Response.Builder.class), callSiteArray[10].call(Status.class, callSiteArray[11].callGetProperty(HttpStatus.class))), (Object)payload));
                response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
            } else {
                Object object = callSiteArray[12].callCurrent((GroovyObject)this, callSiteArray[13].call(Status.class, callSiteArray[14].callGetProperty(HttpStatus.class)));
                response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
            }
            return response;
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
            return callSiteArray[15].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure19.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "authenticate";
            stringArray[1] = "tokenManager";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "writeValueAsString";
            stringArray[4] = "mapper";
            stringArray[5] = "APPLICATION_JSON";
            stringArray[6] = "build";
            stringArray[7] = "payload";
            stringArray[8] = "status";
            stringArray[9] = "<$constructor$>";
            stringArray[10] = "success";
            stringArray[11] = "OK";
            stringArray[12] = "toResponse";
            stringArray[13] = "failure";
            stringArray[14] = "FORBIDDEN";
            stringArray[15] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[16];
            _closure19.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure19.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure19.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    class _closure20
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure20(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Context context) {
            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)context), ProxyFacet.class)))) {
                Object name = callSiteArray[3].callCurrent((GroovyObject)this, callSiteArray[4].call(callSiteArray[5].callGetProperty((Object)context), TokenMatcher.State.class), (Object)"name");
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(name, (Object)"/"), (Object)-1)) {
                    Object path = callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty((Object)context));
                    Object libraryPath = callSiteArray[9].call(path, (Object)new GStringImpl(new Object[]{name}, new String[]{"\\Q", "\\E"}), (Object)new GStringImpl(new Object[]{name}, new String[]{"library/", ""}));
                    callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{name, path, libraryPath}, new String[]{"Updating library request for: ", " and path: ", " to: ", ""}));
                    Request updatedRequest = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].callConstructor(Request.Builder.class), callSiteArray[16].callGetProperty((Object)context)), libraryPath)), Request.class);
                    return callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call((Object)context), ViewFacet.class), (Object)updatedRequest, (Object)context);
                }
            }
            return callSiteArray[20].call((Object)context);
        }

        public Object call(Context context) {
            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
            return callSiteArray[21].callCurrent((GroovyObject)this, (Object)context);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure20.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "shouldIncludeLibraryNamespace";
            stringArray[1] = "facet";
            stringArray[2] = "repository";
            stringArray[3] = "requireState";
            stringArray[4] = "require";
            stringArray[5] = "attributes";
            stringArray[6] = "indexOf";
            stringArray[7] = "path";
            stringArray[8] = "request";
            stringArray[9] = "replaceFirst";
            stringArray[10] = "trace";
            stringArray[11] = "log";
            stringArray[12] = "build";
            stringArray[13] = "path";
            stringArray[14] = "copy";
            stringArray[15] = "<$constructor$>";
            stringArray[16] = "request";
            stringArray[17] = "dispatch";
            stringArray[18] = "facet";
            stringArray[19] = "getRepository";
            stringArray[20] = "proceed";
            stringArray[21] = "doCall";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[22];
            _closure20.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure20.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure20.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

