/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.CharStreams;
import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfig;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfigDowngrader;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema1;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema2;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class V2ManifestUtilImpl
extends ComponentSupport
implements V2ManifestUtil,
GroovyObject {
    private static final byte[] EMPTY_BLOB_BYTES;
    private static final String SIGNATURE_BLOCK = "(?s),\\s*\"signatures\".*]";
    private static final ObjectMapper MAPPER;
    @Inject
    private V2ManifestConfigDowngrader v2ManifestConfigDowngrader;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes;

    public V2ManifestUtilImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        byte[] byArray = (byte[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{31, 139, 8, 0, 0, 9, 110, 136, 0, 255, 98, 24, 5, 163, 96, 20, 140, 88, 0, 8, 0, 0, 255, 255, 46, 175, 181, 239, 0, 4, 0, 0}), byte[].class);
        EMPTY_BLOB_BYTES = byArray;
        Object object = V2ManifestUtilImpl.$getCallSiteArray()[0].callConstructor(ObjectMapper.class);
        MAPPER = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        V2ManifestUtilImpl.$getCallSiteArray()[1].call((Object)MAPPER, V2ManifestUtilImpl.$getCallSiteArray()[2].callGetProperty(SerializationFeature.class));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V2Manifest readManifest(Supplier<InputStream> manifestContent, String name, @Nullable String contentType) throws IOException {
        Object schemaVersion;
        Map manifest;
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        callSiteArray[3].callStatic(Preconditions.class, manifestContent);
        callSiteArray[4].callStatic(Preconditions.class, (Object)name);
        String string = contentType;
        callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} of type {}", (Object)name, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "unspecified"));
        try {
            manifest = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call((Object)MAPPER, callSiteArray[8].call(manifestContent), callSiteArray[9].callGetProperty(DockerFacetUtils.class)), Map.class);
            schemaVersion = callSiteArray[10].call((Object)manifest, (Object)"schemaVersion");
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].callGetProperty(V2Manifest.class), (Object)schemaVersion)) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)manifest, (Object)"signatures"))) return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", callSiteArray[17].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", callSiteArray[18].callGetProperty((Object)V2ManifestUtilImpl.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()), "manifest", manifest})), V2Manifest.class);
                return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", callSiteArray[14].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", callSiteArray[15].callGetProperty((Object)V2ManifestUtilImpl.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()), "manifest", manifest})), V2Manifest.class);
            }
        }
        catch (JsonProcessingException e) {
            callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} failed, due to processing exception", (Object)name, (Object)e);
            throw (Throwable)callSiteArray[26].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, callSiteArray[27].call((Object)e)}, new String[]{"Corrupt manifest ", ": ", ""}));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty(V2Manifest.class), (Object)schemaVersion)) throw (Throwable)callSiteArray[23].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, schemaVersion}, new String[]{"Invalid manifest ", ": unknown 'schemaVersion' ", ""}));
            return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", callSiteArray[21].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", callSiteArray[22].callGetProperty((Object)V2ManifestUtilImpl.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()), "manifest", manifest})), V2Manifest.class);
        }
    }

    @Override
    @Transactional
    public Content mayDowngrade(Content manifestContent, String name, String tag, V2Manifest.SchemaVersion clientPreference, Repository repository) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        callSiteArray[28].call(callSiteArray[29].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade manifest check on {}:{}", (Object)name, (Object)tag);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest))) {
            StorageTx tx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(UnitOfWork.class), StorageTx.class);
            callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)this), (Object)"Downgrading manifest on {}:{} based on client preference", (Object)name, (Object)tag);
            V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(V2ManifestSchema2.class, callSiteArray[36].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
            Bucket bucket = (Bucket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call((Object)tx, (Object)repository), Bucket.class);
            V2ManifestConfig config = (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callStatic(V2ManifestUtilImpl.class, (Object)tx, (Object)bucket, (Object)schemaV2), V2ManifestConfig.class);
            callSiteArray[39].callStatic(V2ManifestUtilImpl.class, (Object)config, (Object)tx, (Object)bucket, callSiteArray[40].callGetProperty((Object)repository));
            V2ManifestSchema1 downgradedManifest = (V2ManifestSchema1)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call((Object)this.v2ManifestConfigDowngrader, (Object)config, (Object)schemaV2, (Object)name, (Object)tag), V2ManifestSchema1.class);
            callSiteArray[42].call(callSiteArray[43].callGroovyObjectGetProperty((Object)this), (Object)"Downgraded manifest = {}", callSiteArray[44].call(JsonOutput.class, callSiteArray[45].call(JsonOutput.class, (Object)downgradedManifest)));
            Content content = (Content)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callConstructor(Content.class, callSiteArray[47].callConstructor(BytesPayload.class, callSiteArray[48].call((Object)MAPPER, (Object)downgradedManifest), callSiteArray[49].callGetProperty((Object)V2ManifestUtilImpl.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()))), Content.class);
            callSiteArray[50].call(callSiteArray[51].callGetProperty((Object)content), CacheInfo.class, callSiteArray[52].callConstructor(CacheInfo.class, callSiteArray[53].call(DateTime.class), null));
            return content;
        }
        callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade not needed on {}:{}", (Object)name, (Object)tag);
        return manifestContent;
    }

    @Override
    public DockerDigest manifestDigest(Supplier<InputStream> manifestContent) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call(callSiteArray[57].call(manifestContent), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _manifestDigest_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure1.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Object object = callSiteArray[3].call(callSiteArray[4].call((Object)manifest, callSiteArray[5].call(callSiteArray[6].callGetProperty(V2ManifestUtilImpl.class), (Object)"\n\n"), (Object)"\n"), callSiteArray[7].callGetProperty(V2ManifestUtilImpl.class), (Object)"");
                manifest = ShortTypeHandling.castToString((Object)object);
                return callSiteArray[8].callConstructor(DockerDigest.class, callSiteArray[9].call(callSiteArray[10].callGetProperty(DockerFacetUtils.class)), callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[15].callGetProperty(StandardCharsets.class))));
            }

            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure1.$getCallSiteArray();
                return callSiteArray[16].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _manifestDigest_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "replaceAll";
                stringArray[4] = "replaceAll";
                stringArray[5] = "plus";
                stringArray[6] = "SIGNATURE_BLOCK";
                stringArray[7] = "SIGNATURE_BLOCK";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "name";
                stringArray[10] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[11] = "toString";
                stringArray[12] = "hashString";
                stringArray[13] = "function";
                stringArray[14] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[15] = "UTF_8";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _manifestDigest_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_manifestDigest_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _manifestDigest_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), DockerDigest.class);
    }

    @Override
    public boolean shouldDowngrade(Content manifestContent, String name, V2Manifest.SchemaVersion clientPreference) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        Supplier inputStreamSupplier = (Supplier)ScriptBytecodeAdapter.castToType((Object)new GeneratedClosure(this, this, manifestContent2){
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _shouldDowngrade_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _shouldDowngrade_closure2.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            public Content getManifestContent() {
                CallSite[] callSiteArray = _shouldDowngrade_closure2.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _shouldDowngrade_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldDowngrade_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_shouldDowngrade_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _shouldDowngrade_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }, Supplier.class);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[59].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest));
    }

    @Override
    public DockerDigest findConfigDigest(Content manifestContent, String name) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[62].callGroovyObjectGetProperty((Object)manifest), (Object)callSiteArray[63].callGetProperty(V2Manifest.SchemaVersion.class))) {
            throw (Throwable)callSiteArray[64].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[65].callGroovyObjectGetProperty((Object)manifest)}, new String[]{"Config file is not specified in schemaVersion: ", ""}));
        }
        V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callConstructor(V2ManifestSchema2.class, callSiteArray[67].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call(DockerDigest.class, callSiteArray[69].callGetProperty(callSiteArray[70].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
    }

    /*
     * WARNING - void declaration
     */
    public static void insertEmptyLayerIfNeeded(V2ManifestConfig config, StorageTx tx, Bucket bucket, Format format) {
        void var3_3;
        void var2_2;
        Reference tx2 = new Reference((Object)tx);
        Reference bucket2 = new Reference((Object)var2_2);
        Reference format2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)config), (Object)new GeneratedClosure(V2ManifestUtilImpl.class, V2ManifestUtilImpl.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(it), (Object)"empty_layer");
            }

            public Object doCall() {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "keySet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _insertEmptyLayerIfNeeded_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_insertEmptyLayerIfNeeded_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _insertEmptyLayerIfNeeded_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }))) {
            Object emptyBlobDigest = callSiteArray[73].call(DockerDigest.class, callSiteArray[74].callGetProperty(V2ManifestUtilImpl.class));
            Object emptyBlob = callSiteArray[75].call(DockerFacetUtils.class, (Object)((StorageTx)tx2.get()), (Object)((Bucket)bucket2.get()), emptyBlobDigest);
            if (ScriptBytecodeAdapter.compareEqual((Object)emptyBlob, null)) {
                Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(DockerFacetUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)((Bucket)bucket2.get()), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Supplier)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(V2ManifestUtilImpl.class, V2ManifestUtilImpl.class, bucket2, tx2, format2){
                    private /* synthetic */ Reference bucket;
                    private /* synthetic */ Reference tx;
                    private /* synthetic */ Reference format;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.bucket = reference3 = bucket;
                        this.tx = reference2 = tx;
                        this.format = reference = format;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        return callSiteArray[0].call(this.tx.get(), this.bucket.get(), this.format.get());
                    }

                    public Bucket getBucket() {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        return (Bucket)ScriptBytecodeAdapter.castToType((Object)this.bucket.get(), Bucket.class);
                    }

                    public StorageTx getTx() {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        return (StorageTx)ScriptBytecodeAdapter.castToType((Object)this.tx.get(), StorageTx.class);
                    }

                    public Format getFormat() {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        return (Format)ScriptBytecodeAdapter.castToType((Object)this.format.get(), Format.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "createAsset";
                        return new CallSiteArray(_insertEmptyLayerIfNeeded_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _insertEmptyLayerIfNeeded_closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }, Supplier.class)), Supplier.class), (Object)callSiteArray[77].call(DockerFacetUtils.class, emptyBlobDigest), (Object)emptyBlobDigest)), Asset.class);
                Supplier inputStreamSupplier = (Supplier)ScriptBytecodeAdapter.castToType((Object)new GeneratedClosure(V2ManifestUtilImpl.class, V2ManifestUtilImpl.class){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                        return callSiteArray[0].callConstructor(ByteArrayInputStream.class, callSiteArray[1].callGetProperty(V2ManifestUtilImpl.class));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "<$constructor$>";
                        stringArray[1] = "EMPTY_BLOB_BYTES";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_insertEmptyLayerIfNeeded_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }, Supplier.class);
                callSiteArray[78].call(DockerFacetUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)asset, (Object)inputStreamSupplier, (Object)emptyBlobDigest, (Object)callSiteArray[79].callGetProperty((Object)V2ManifestUtilImpl.$get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes()), null));
            }
        }
    }

    public static V2ManifestConfig loadConfigurationFile(StorageTx tx, Bucket bucket, V2ManifestSchema2 schemaV2) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call(DockerDigest.class, callSiteArray[81].callGetProperty(callSiteArray[82].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
        Asset configAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].call(DockerFacetUtils.class, (Object)tx, (Object)bucket, (Object)digest), Asset.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)configAsset, null)) {
            throw (Throwable)callSiteArray[84].callConstructor(V2Exception.BlobNotFound.class, (Object)digest);
        }
        return (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].call((Object)MAPPER, callSiteArray[86].callGetProperty(callSiteArray[87].call((Object)tx, callSiteArray[88].call((Object)configAsset))), V2ManifestConfig.class), V2ManifestConfig.class);
    }

    private V2Manifest readManifestContent(Content manifestContent, String name) {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        Supplier inputStreamSupplier = (Supplier)ScriptBytecodeAdapter.castToType((Object)new GeneratedClosure(this, this, manifestContent2){
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            public Content getManifestContent() {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _readManifestContent_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readManifestContent_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_readManifestContent_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readManifestContent_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }, Supplier.class);
        return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[90].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
    }

    private static boolean downgradeRequired(V2Manifest.SchemaVersion clientPreference, V2Manifest manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[91].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[92].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[93].callGroovyObjectGetProperty((Object)manifest));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[94].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[95].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[96].callGroovyObjectGetProperty((Object)manifest));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != V2ManifestUtilImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static final ObjectMapper getMAPPER() {
        return MAPPER;
    }

    public V2ManifestConfigDowngrader getV2ManifestConfigDowngrader() {
        return this.v2ManifestConfigDowngrader;
    }

    public void setV2ManifestConfigDowngrader(V2ManifestConfigDowngrader v2ManifestConfigDowngrader) {
        this.v2ManifestConfigDowngrader = v2ManifestConfigDowngrader;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "enable";
        stringArray[2] = "INDENT_OUTPUT";
        stringArray[3] = "checkNotNull";
        stringArray[4] = "checkNotNull";
        stringArray[5] = "debug";
        stringArray[6] = "log";
        stringArray[7] = "readValue";
        stringArray[8] = "get";
        stringArray[9] = "JSON_AS_MAP_TYPE_REF";
        stringArray[10] = "getAt";
        stringArray[11] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[12] = "containsKey";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "Schema1";
        stringArray[15] = "V2_MANIFEST_SCHEMA_1_SIGNED";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "Schema1";
        stringArray[18] = "V2_MANIFEST_SCHEMA_1";
        stringArray[19] = "V2_MANIFEST_SCHEMA2_VERSION";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "Schema2";
        stringArray[22] = "V2_MANIFEST_SCHEMA_2";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "debug";
        stringArray[25] = "log";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "getMessage";
        stringArray[28] = "debug";
        stringArray[29] = "log";
        stringArray[30] = "readManifestContent";
        stringArray[31] = "downgradeRequired";
        stringArray[32] = "currentTx";
        stringArray[33] = "debug";
        stringArray[34] = "log";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "manifest";
        stringArray[37] = "findBucket";
        stringArray[38] = "loadConfigurationFile";
        stringArray[39] = "insertEmptyLayerIfNeeded";
        stringArray[40] = "format";
        stringArray[41] = "downgrade";
        stringArray[42] = "debug";
        stringArray[43] = "log";
        stringArray[44] = "prettyPrint";
        stringArray[45] = "toJson";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "writeValueAsBytes";
        stringArray[49] = "V2_MANIFEST_SCHEMA_1";
        stringArray[50] = "set";
        stringArray[51] = "attributes";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "now";
        stringArray[54] = "debug";
        stringArray[55] = "log";
        stringArray[56] = "withCloseable";
        stringArray[57] = "get";
        stringArray[58] = "readManifest";
        stringArray[59] = "contentType";
        stringArray[60] = "downgradeRequired";
        stringArray[61] = "readManifestContent";
        stringArray[62] = "schemaVersion";
        stringArray[63] = "Schema2";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "schemaVersion";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "manifest";
        stringArray[68] = "parse";
        stringArray[69] = "digest";
        stringArray[70] = "config";
        stringArray[71] = "any";
        stringArray[72] = "history";
        stringArray[73] = "parse";
        stringArray[74] = "EMPTY_BLOB_DIGEST";
        stringArray[75] = "findAssetByContentDigest";
        stringArray[76] = "getOrCreateAsset";
        stringArray[77] = "blobName";
        stringArray[78] = "saveAsset";
        stringArray[79] = "V2_BLOB_IMAGE_LAYER";
        stringArray[80] = "parse";
        stringArray[81] = "digest";
        stringArray[82] = "config";
        stringArray[83] = "findAssetByContentDigest";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "readValue";
        stringArray[86] = "inputStream";
        stringArray[87] = "requireBlob";
        stringArray[88] = "requireBlobRef";
        stringArray[89] = "readManifest";
        stringArray[90] = "contentType";
        stringArray[91] = "Schema1";
        stringArray[92] = "Schema2";
        stringArray[93] = "schemaVersion";
        stringArray[94] = "Schema1";
        stringArray[95] = "Schema2";
        stringArray[96] = "schemaVersion";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[97];
        V2ManifestUtilImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(V2ManifestUtilImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = V2ManifestUtilImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes() {
        Class clazz = $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes;
        if (clazz == null) {
            clazz = $class$org$sonatype$nexus$repository$docker$internal$V2ContentTypes = V2ManifestUtilImpl.class$("org.sonatype.nexus.repository.docker.internal.V2ContentTypes");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

