/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.auth;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.docker.internal.auth.BearerCredentials;

public class BearerScheme
extends RFC2617Scheme {
    private static final Logger log = LoggerFactory.getLogger(BearerScheme.class);
    public static final String SCHEME_NAME = "Bearer";
    private boolean complete = false;

    public BearerScheme() {
        super(Consts.ASCII);
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Preconditions.checkNotNull((Object)credentials);
        Preconditions.checkArgument((boolean)(credentials instanceof BearerCredentials));
        try {
            String realm = this.requireParameter("realm");
            String service = this.optionalParameter("service");
            String scope = this.optionalParameter("scope");
            String token = ((BearerCredentials)credentials).getToken(realm, service, scope);
            CharArrayBuffer buffer = new CharArrayBuffer(22 + token.length());
            buffer.append("Authorization");
            buffer.append(": Bearer ");
            buffer.append(token);
            return new BufferedHeader(buffer);
        }
        catch (AuthenticationException e) {
            log.warn("Failed to retrieve docker bearer token", (Throwable)e);
            throw e;
        }
    }

    private String optionalParameter(String name) {
        return Optional.ofNullable(this.getParameter(name)).orElse("");
    }

    private String requireParameter(String name) throws AuthenticationException {
        String value = this.getParameter(name);
        if (value == null) {
            throw new AuthenticationException("Could not retrieve token due to missing parameter: " + name);
        }
        return value;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, (HttpContext)new BasicHttpContext());
    }

    public String toString() {
        return "BEARER [complete=" + this.complete + "]";
    }
}

