/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.auth;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.sonatype.nexus.repository.docker.internal.auth.BearerCredentials;
import org.sonatype.nexus.repository.docker.internal.auth.BearerSchemeFactory;
import org.sonatype.nexus.repository.docker.internal.auth.TokenCredentials;
import org.sonatype.nexus.repository.docker.internal.auth.TokenSchemeFactory;

public abstract class DockerAuthHttpClientContext
extends HttpClientContext {
    private static final TokenSchemeFactory tokenSchemeFactory = new TokenSchemeFactory();
    private static final BearerSchemeFactory bearerSchemeFactory = new BearerSchemeFactory();
    private final AuthScope tokenAuthScope;
    private final AuthScope bearerAuthScope;
    private RequestConfig requestConfig;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;

    public DockerAuthHttpClientContext(URI url) {
        super((HttpContext)new BasicHttpContext());
        this.tokenAuthScope = new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM, "Token");
        this.bearerAuthScope = new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM, "Bearer");
    }

    public CredentialsProvider getCredentialsProvider() {
        CredentialsProvider credentialsProvider = super.getCredentialsProvider();
        if (credentialsProvider == null) {
            credentialsProvider = new BasicCredentialsProvider();
            this.setCredentialsProvider(credentialsProvider);
        }
        credentialsProvider.setCredentials(this.tokenAuthScope, (Credentials)new TokenCredentials(){

            @Override
            public String getToken() throws AuthenticationException {
                return DockerAuthHttpClientContext.this.retrieveToken();
            }
        });
        credentialsProvider.setCredentials(this.bearerAuthScope, (Credentials)new BearerCredentials(){

            @Override
            public String getToken(String realm, String service, String scope) throws AuthenticationException {
                return DockerAuthHttpClientContext.this.retrieveBearerToken(realm, service, scope);
            }
        });
        return credentialsProvider;
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        if (this.authSchemeRegistry == null) {
            Lookup defaultAuthSchemeRegistry = super.getAuthSchemeRegistry();
            this.authSchemeRegistry = name -> {
                if ("Token".equals(name)) {
                    return tokenSchemeFactory;
                }
                if ("Bearer".equals(name)) {
                    return bearerSchemeFactory;
                }
                return (AuthSchemeProvider)defaultAuthSchemeRegistry.lookup(name);
            };
        }
        return this.authSchemeRegistry;
    }

    public RequestConfig getRequestConfig() {
        if (this.requestConfig == null) {
            RequestConfig defaultRequestConfig = super.getRequestConfig();
            ArrayList authSchemes = Lists.newArrayList((Object[])new String[]{"Token", "Bearer", "NTLM", "Digest", "Basic"});
            this.requestConfig = RequestConfig.copy((RequestConfig)defaultRequestConfig).setTargetPreferredAuthSchemes((Collection)authSchemes).build();
        }
        return this.requestConfig;
    }

    protected abstract String retrieveToken() throws AuthenticationException;

    protected abstract String retrieveBearerToken(String var1, String var2, String var3) throws AuthenticationException;
}

