/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.auth;

import com.google.common.base.Preconditions;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.docker.internal.auth.TokenCredentials;

public class TokenScheme
extends RFC2617Scheme {
    private static final Logger log = LoggerFactory.getLogger(TokenScheme.class);
    public static final String SCHEME_NAME = "Token";
    private boolean complete = false;

    public TokenScheme() {
        super(Consts.ASCII);
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Preconditions.checkNotNull((Object)credentials);
        Preconditions.checkArgument((boolean)(credentials instanceof TokenCredentials));
        try {
            String token = ((TokenCredentials)credentials).getToken();
            CharArrayBuffer buffer = new CharArrayBuffer(21 + token.length());
            buffer.append("Authorization");
            buffer.append(": Token ");
            buffer.append(token);
            return new BufferedHeader(buffer);
        }
        catch (AuthenticationException e) {
            log.warn("Failed to retrieve docker token", (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, (HttpContext)new BasicHttpContext());
    }

    public String toString() {
        return "TOKEN [complete=" + this.complete + "]";
    }
}

