/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.security;

import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.token.BearerTokenManager;

@Named
@Singleton
public class DockerTokenManager
extends BearerTokenManager {
    @Inject
    public DockerTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper) {
        super(apiKeyStore, securityHelper, "DockerToken");
    }

    @Nullable
    public String authenticate() {
        boolean authenticated;
        Subject subject = this.securityHelper.subject();
        boolean bl = authenticated = subject.getPrincipal() != null && subject.isAuthenticated();
        if (authenticated || AnonymousHelper.isAnonymous((Subject)subject)) {
            PrincipalCollection principals = subject.getPrincipals();
            return super.createToken(principals);
        }
        return null;
    }
}

