/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.0", to="1.1")
@DependsOn(model="config", version="1.2")
public class ComponentDatabaseUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String SELECT_DOCKER_REPOSITORIES = "select from repository where recipe_name in ['docker-hosted', 'docker-proxy']";
    private static final String UPDATE_ASSET_KIND = "update asset set attributes.docker.asset_kind='BLOB' where bucket=? and name like '%/blobs/%' and attributes.docker.asset_kind='MANIFEST'";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_1(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (ComponentDatabaseUpgrade_1_1.hasSchemaClass(this.configDatabaseInstance, (String)"repository") && ComponentDatabaseUpgrade_1_1.hasSchemaClass(this.componentDatabaseInstance, (String)"asset")) {
            this.updateDockerBlobAssetKind();
        }
    }

    private void updateDockerBlobAssetKind() {
        List<String> dockerRepositoryNames;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            dockerRepositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_DOCKER_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (!dockerRepositoryNames.isEmpty()) {
            OCommandSQL updateAssetCommand = new OCommandSQL(UPDATE_ASSET_KIND);
            throwable2 = null;
            Object var4_6 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
                dockerRepositoryNames.forEach(repositoryName -> {
                    this.log.info("Scanning docker repository, {}, for misconfigured assets", repositoryName);
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
                    if (bucket == null) {
                        this.log.warn("Unable to find bucket for {}", repositoryName);
                    } else {
                        int updates = (Integer)db.command((OCommandRequest)updateAssetCommand).execute(new Object[]{bucket.getIdentity()});
                        if (updates > 0) {
                            this.log.info("Updated {} misconfigured docker asset(s) in repository {}: set attributes.docker.asset_kind='BLOB'", (Object)updates, repositoryName);
                        }
                    }
                });
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
    }
}

