/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.shiro.authc.AuthenticationToken;
import org.sonatype.goodies.common.InternalAccessible;

public class UserToken
implements Serializable,
AuthenticationToken {
    public static final char SEPARATOR = ':';
    private final String nameCode;
    private final char[] passCode;

    @InternalAccessible
    public UserToken(String nameCode, char[] passCode) {
        this.nameCode = (String)Preconditions.checkNotNull((Object)nameCode);
        this.passCode = (char[])Preconditions.checkNotNull((Object)passCode);
        this.validate();
    }

    @InternalAccessible
    public UserToken(String nameCode, String passCode) {
        this(nameCode, ((String)Preconditions.checkNotNull((Object)passCode)).toCharArray());
    }

    private void validate() {
        Preconditions.checkArgument((!this.nameCode.isEmpty() ? 1 : 0) != 0, (Object)"Name-code must not be empty");
        Preconditions.checkArgument((this.nameCode.indexOf(58) == -1 ? 1 : 0) != 0, (String)"Name-code must not contain a '%s' char", (char)':');
        Preconditions.checkArgument((this.passCode.length != 0 ? 1 : 0) != 0, (Object)"Pass-code must not be empty");
        Preconditions.checkArgument((this.length() < 57 ? 1 : 0) != 0, (Object)"Length of token must not exceed 57 chars");
    }

    public static UserToken parse(String value) {
        Preconditions.checkNotNull((Object)value);
        value = value.trim();
        int i = value.indexOf(58);
        Preconditions.checkArgument((i != -1 ? 1 : 0) != 0, (Object)"Missing separator");
        Preconditions.checkArgument((i != 0 ? 1 : 0) != 0, (Object)"Missing name-code");
        Preconditions.checkArgument((i + 1 < value.length() ? 1 : 0) != 0, (Object)"Missing pass-code");
        String nameCode = value.substring(0, i);
        String passCode = value.substring(i + 1, value.length());
        return new UserToken(nameCode, passCode);
    }

    public String getNameCode() {
        return this.nameCode;
    }

    public char[] getPassCode() {
        return this.passCode;
    }

    public String render() {
        return this.getNameCode() + ':' + this.getPassCode();
    }

    public int length() {
        return this.getNameCode().length() + this.getPassCode().length + 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "nameCode='" + this.nameCode + '\'' + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserToken that = (UserToken)obj;
        if (!this.nameCode.equals(that.nameCode)) {
            return false;
        }
        return Arrays.equals(this.passCode, that.passCode);
    }

    public int hashCode() {
        int result = this.nameCode.hashCode();
        result = 31 * result + Arrays.hashCode(this.passCode);
        return result;
    }

    public Object getPrincipal() {
        return this.getNameCode();
    }

    public Object getCredentials() {
        return this.getPassCode();
    }
}

