/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.internal.UserNameHelper;
import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.InternalAccessible;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class UserTokenRecord
extends AbstractEntity
implements Serializable {
    private final PrincipalCollection principals;
    private final UserToken userToken;
    private final Date created;

    @InternalAccessible
    public UserTokenRecord(PrincipalCollection principals, UserToken userToken, Date created) {
        this.principals = (PrincipalCollection)Preconditions.checkNotNull((Object)principals);
        this.userToken = (UserToken)Preconditions.checkNotNull((Object)userToken);
        this.created = (Date)Preconditions.checkNotNull((Object)created);
    }

    @InternalAccessible
    public UserTokenRecord(PrincipalCollection principals, UserToken userToken) {
        this(principals, userToken, new Date());
    }

    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    public String getUserName() {
        return UserNameHelper.get(this.getPrincipals());
    }

    public UserToken getUserToken() {
        return this.userToken;
    }

    public String getNameCode() {
        return this.getUserToken().getNameCode();
    }

    public char[] getPassCode() {
        return this.getUserToken().getPassCode();
    }

    public Date getCreated() {
        return this.created;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "userName='" + this.getUserName() + '\'' + ", principals=" + this.principals + ", userToken=" + this.userToken + ", created=" + this.created + '}';
    }
}

