/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.encoding;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import com.sonatype.nexus.usertoken.plugin.encoding.NameCodeGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.CryptoHelper;

@Named
public class NameCodeGeneratorImpl
extends ComponentSupport
implements NameCodeGenerator {
    private final CryptoHelper crypto;

    @Inject
    public NameCodeGeneratorImpl(CryptoHelper crypto) {
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
    }

    private MessageDigest createDigest() throws NoSuchAlgorithmException {
        return this.crypto.createDigest("SHA1");
    }

    @Override
    public String generate(EncodingStrategy strategy, String input) throws Exception {
        Preconditions.checkNotNull((Object)strategy);
        Preconditions.checkNotNull((Object)input);
        MessageDigest digest = this.createDigest();
        byte[] bytes = digest.digest(input.getBytes());
        String value = strategy.encodeNameCodeBytes(bytes);
        return value.substring(0, strategy.getNameCodeLength());
    }
}

