/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.encoding;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import com.sonatype.nexus.usertoken.plugin.encoding.PassCodeGenerator;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.RandomBytesGenerator;

@Named
public class PassCodeGeneratorImpl
extends ComponentSupport
implements PassCodeGenerator {
    private final RandomBytesGenerator randomBytes;

    @Inject
    public PassCodeGeneratorImpl(RandomBytesGenerator randomBytes) {
        this.randomBytes = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytes);
    }

    @Override
    public char[] generate(EncodingStrategy strategy) throws Exception {
        Preconditions.checkNotNull((Object)strategy);
        byte[] bytes = this.randomBytes.generate(strategy.getPassCodeByteSize());
        return strategy.encodePassCodeBytes(bytes).toCharArray();
    }
}

