/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.realm;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.security.user.UserStatus;

@Named(value="User-Token-Realm")
@Singleton
@Description(value="User Token Realm")
public class UserTokenRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(UserTokenRealm.class);
    public static final String ID = "User-Token-Realm";
    public static final String IS_TOKEN_AUTH_KEY = "com.sonatype.nexus.usertoken.plugin.realm.UserTokenRealm.IS_TOKEN";
    private final UserTokenService userTokens;
    private final UserPrincipalsHelper principalsHelper;
    private final Provider<HttpServletRequest> requestProvider;

    @Inject
    public UserTokenRealm(UserTokenService userTokens, UserPrincipalsHelper principalsHelper, Provider<HttpServletRequest> requestProvider) {
        this.userTokens = (UserTokenService)Preconditions.checkNotNull((Object)userTokens);
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
        this.setCredentialsMatcher(new CredentialsMatcher(){

            public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
                log.debug("Checking for match: token={}, info={}", (Object)token, (Object)info);
                char[] have = (char[])token.getCredentials();
                char[] want = (char[])info.getCredentials();
                boolean result = Arrays.equals(have, want);
                log.debug("Match: {}", (Object)result);
                return result;
            }
        });
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof UserToken || token instanceof UsernamePasswordToken;
    }

    private String principalOf(AuthenticationToken token) {
        if (token instanceof UserToken) {
            return ((UserToken)token).getNameCode();
        }
        if (token instanceof UsernamePasswordToken) {
            return ((UsernamePasswordToken)token).getUsername();
        }
        throw new Error();
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        if (!this.userTokens.isEnabled()) {
            log.trace("Skipping; feature is not enabled");
            return null;
        }
        log.trace("Attempting user-token authentication w/token: {}", (Object)token);
        return this.handle(token);
    }

    private AuthenticationInfo handle(AuthenticationToken token) {
        String principal = this.principalOf(token);
        log.debug("Looking up record for: {}", (Object)principal);
        UserTokenRecord record = this.userTokens.lookup(principal);
        if (record != null) {
            try {
                if (UserStatus.active.equals((Object)this.principalsHelper.getUserStatus(record.getPrincipals()))) {
                    if (Objects.equals(principal, record.getNameCode())) {
                        ((HttpServletRequest)this.requestProvider.get()).setAttribute(IS_TOKEN_AUTH_KEY, (Object)Boolean.TRUE);
                    }
                    SimpleAuthenticationInfo authInfo = new SimpleAuthenticationInfo(record.getPrincipals(), (Object)record.getPassCode());
                    log.debug("Auth-info: {}", (Object)authInfo);
                    return authInfo;
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                log.debug("Removing stale user-token, target principals are no longer valid");
                this.userTokens.remove(principal);
            }
        }
        return null;
    }
}

