/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest;

import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.rest.UserTokenResourceSupport;
import com.sonatype.nexus.usertoken.plugin.rest.model.UserTokenXO;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresPermissions;

@Named
@Singleton
@Path(value="/usertoken/current")
public class CurrentResource
extends UserTokenResourceSupport {
    public static final String RESOURCE_URI = "/usertoken/current";

    @GET
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:usertoken-current:read"})
    public UserTokenXO get(@HeaderParam(value="X-NX-AuthTicket") String authTicket) {
        this.validateAuthTicket(authTicket);
        UserTokenRecord record = this.getUserTokens().current(true);
        return new UserTokenXO().withNameCode(record.getUserToken().getNameCode()).withPassCode(new String(record.getUserToken().getPassCode())).withCreated(record.getCreated());
    }

    @DELETE
    @RequiresPermissions(value={"nexus:usertoken-current:delete"})
    public void delete(@HeaderParam(value="X-NX-AuthTicket") String authTicket) {
        this.validateAuthTicket(authTicket);
        UserTokenRecord record = this.getUserTokens().current(false);
        if (record != null) {
            this.getUserTokens().remove(record.getUserName());
        }
    }
}

