/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest;

import com.sonatype.nexus.usertoken.plugin.rest.UserTokenResourceSupport;
import com.sonatype.nexus.usertoken.plugin.rest.model.SettingsXO;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresPermissions;

@Named
@Singleton
@Path(value="/usertoken/settings")
public class SettingsResource
extends UserTokenResourceSupport {
    public static final String RESOURCE_URI = "/usertoken/settings";

    @GET
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:usertoken-settings:read"})
    public SettingsXO get() {
        return new SettingsXO().withEnabled(this.getUserTokens().isEnabled()).withProtectContent(this.getUserTokens().isProtectContent()).withRealmConfigured(this.getUserTokens().isRealmConfigured());
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:usertoken-settings:update"})
    public SettingsXO put(SettingsXO settings) {
        this.getUserTokens().setEnabled(settings.isEnabled());
        this.getUserTokens().setProtectContent(settings.isProtectContent());
        return this.get();
    }
}

