/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest;

import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.rest.UserTokenResourceSupport;
import com.sonatype.nexus.usertoken.plugin.rest.model.UserTokenStatusXO;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresPermissions;

@Named
@Singleton
@Path(value="/usertoken/users/{userName}")
public class UserResource
extends UserTokenResourceSupport {
    public static final String USER_NAME = "userName";
    public static final String RESOURCE_URI = "/usertoken/users/{userName}";

    @GET
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:usertoken-user:read"})
    public UserTokenStatusXO get(@PathParam(value="userName") String userName) {
        UserTokenRecord record = this.getUserTokens().get(userName);
        UserTokenStatusXO status = new UserTokenStatusXO().withProvisioned(record != null);
        if (record != null) {
            status.setCreated(record.getCreated());
        }
        return status;
    }

    @DELETE
    @RequiresPermissions(value={"nexus:usertoken-user:delete"})
    public void delete(@HeaderParam(value="X-NX-AuthTicket") String authTicket, @PathParam(value="userName") String userName) {
        this.validateAuthTicket(authTicket);
        this.getUserTokens().remove(userName);
    }
}

