/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.rest.Resource;

public abstract class UserTokenResourceSupport
extends ComponentSupport
implements Resource {
    private UserTokenService userTokens;
    private AuthTicketService authTickets;

    @Inject
    public void installComponents(UserTokenService userTokens, AuthTicketService authTickets) {
        this.userTokens = (UserTokenService)Preconditions.checkNotNull((Object)userTokens);
        this.authTickets = (AuthTicketService)Preconditions.checkNotNull((Object)authTickets);
    }

    protected UserTokenService getUserTokens() {
        Preconditions.checkState((this.userTokens != null ? 1 : 0) != 0);
        return this.userTokens;
    }

    protected void validateAuthTicket(String ticket) {
        this.log.debug("Validating authentication ticket: {}", (Object)ticket);
        if (ticket == null) {
            throw new WebApplicationException("Missing authentication ticket", Response.Status.BAD_REQUEST);
        }
        if (!this.authTickets.redeemTicket(ticket)) {
            throw new WebApplicationException("Invalid authentication ticket", Response.Status.FORBIDDEN);
        }
    }
}

