/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class Iso8601DateAdapter
extends XmlAdapter<String, Date> {
    private static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private static DateFormat getFormat() {
        return (DateFormat)FORMAT.clone();
    }

    public Date unmarshal(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            return Iso8601DateAdapter.getFormat().parse(value);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(value);
        }
    }

    public String marshal(Date value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return Iso8601DateAdapter.getFormat().format(value);
    }
}

