/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateNameCodeException;
import com.sonatype.nexus.usertoken.plugin.store.RecordNotFoundException;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
public class TransientUserTokenStore
extends StateGuardLifecycleSupport
implements UserTokenStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, UserTokenRecord> recordsByUserName = Maps.newHashMap();
    private final Map<String, UserTokenRecord> recordsByNameCode = Maps.newHashMap();

    @Override
    public void add(UserTokenRecord record) throws DuplicateNameCodeException {
        Preconditions.checkNotNull((Object)record);
        UserToken userToken = record.getUserToken();
        String userName = record.getUserName();
        String nameCode = userToken.getNameCode();
        this.lock.readLock().lock();
        try {
            if (this.recordsByNameCode.containsKey(nameCode)) {
                throw new DuplicateNameCodeException(nameCode);
            }
            Preconditions.checkState((!this.recordsByUserName.containsKey(userName) ? 1 : 0) != 0, (String)"Record for user-name '%s' already exists", (Object)userName);
            this.recordsByUserName.put(record.getUserName(), record);
            this.recordsByNameCode.put(nameCode, record);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void remove(String userName) {
        Preconditions.checkNotNull((Object)userName);
        this.lock.writeLock().lock();
        try {
            UserTokenRecord record = this.recordsByUserName.remove(userName);
            if (record != null) {
                this.recordsByNameCode.remove(record.getNameCode());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(String userName) {
        Preconditions.checkNotNull((Object)userName);
        this.lock.readLock().lock();
        try {
            boolean bl = this.recordsByUserName.containsKey(userName);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord get(String userName) {
        Preconditions.checkNotNull((Object)userName);
        this.lock.readLock().lock();
        try {
            UserTokenRecord userTokenRecord = this.recordsByUserName.get(userName);
            return userTokenRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.recordsByUserName.clear();
            this.recordsByNameCode.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.recordsByUserName.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<UserTokenRecord> records() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.recordsByUserName.values());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord lookup(String principal, boolean allowUserName) throws RecordNotFoundException {
        Preconditions.checkNotNull((Object)principal);
        this.lock.readLock().lock();
        try {
            UserTokenRecord record = null;
            if (allowUserName) {
                record = this.recordsByUserName.get(principal);
            }
            if (record == null) {
                record = this.recordsByNameCode.get(principal);
            }
            if (record == null) {
                throw new RecordNotFoundException(principal);
            }
            UserTokenRecord userTokenRecord = record;
            return userTokenRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public UserTokenRecord lookup(String userNameOrCode) throws RecordNotFoundException {
        return this.lookup(userNameOrCode, true);
    }
}

