/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateNameCodeException;
import com.sonatype.nexus.usertoken.plugin.store.RecordNotFoundException;
import com.sonatype.nexus.usertoken.plugin.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.store.orient.UserTokenRecordEntityAdapter;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientUserTokenStore
extends StateGuardLifecycleSupport
implements UserTokenStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final UserTokenRecordEntityAdapter entityAdapter;

    @Inject
    public OrientUserTokenStore(@Named(value="security") Provider<DatabaseInstance> databaseInstance, UserTokenRecordEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (UserTokenRecordEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void add(UserTokenRecord record) throws DuplicateNameCodeException {
        Preconditions.checkNotNull((Object)record);
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)record);
            });
        }
        catch (ORecordDuplicatedException oRecordDuplicatedException) {
            throw new DuplicateNameCodeException(record.getNameCode());
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void remove(String userName) {
        Preconditions.checkNotNull((Object)userName);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.deleteByUsername(db, userName);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean contains(String userName) {
        Preconditions.checkNotNull((Object)userName);
        return (Boolean)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.contains(db, userName));
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord get(String userName) {
        Preconditions.checkNotNull((Object)userName);
        return (UserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, userName, true, false));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<UserTokenRecord> records() {
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.getAll(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void clear() {
        OrientTransactional.inTxRetry(this.databaseInstance).run(this.entityAdapter::deleteAll);
    }

    @Override
    @Guarded(by={"STARTED"})
    public int size() {
        return (Integer)OrientTransactional.inTx(this.databaseInstance).call(db -> (int)this.entityAdapter.count(db));
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord lookup(String userNameOrCode) throws RecordNotFoundException {
        return this.lookup(userNameOrCode, true);
    }

    @Override
    @Guarded(by={"STARTED"})
    public UserTokenRecord lookup(String principal, boolean allowUserName) throws RecordNotFoundException {
        Preconditions.checkNotNull((Object)principal);
        UserTokenRecord record = (UserTokenRecord)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, principal, allowUserName, true));
        if (record == null) {
            throw new RecordNotFoundException(principal);
        }
        return record;
    }
}

