/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.store.orient;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;

public class UserTokenRecordEntityAdapter
extends IterableEntityAdapter<UserTokenRecord> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("usertoken").type("record").build();
    private static final String P_USERNAME = "username";
    private static final String P_PRINCIPALS = "principals";
    private static final String P_NAMECODE = "namecode";
    private static final String P_PASSCODE = "passcode";
    private static final String P_CREATED = "created";
    private static final String I_USERNAME = new OIndexNameBuilder().type(DB_CLASS).property("username").build();
    private static final String I_NAMECODE = new OIndexNameBuilder().type(DB_CLASS).property("namecode").build();
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);
    private final DeleteEntityByPropertyAction deleteByUsername = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"username"});
    private static final String COUNT_QUERY = String.format("SELECT COUNT(*) FROM %s", DB_CLASS);
    private static final String CONTAINS_QUERY = String.format("SELECT COUNT(*) FROM %s WHERE %s = ?", DB_CLASS, "username");
    private static final String GET_USERNAME_OR_NAMECODE_QUERY = String.format("SELECT FROM %s WHERE %s = ? OR %s = ?", DB_CLASS, "username", "namecode");
    private static final String GET_USERNAME_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "username");
    private static final String GET_NAMECODE_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "namecode");

    public UserTokenRecordEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(db, type);
        this.enableRecordEncryption(db, type);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_USERNAME, OType.STRING);
        type.createProperty(P_NAMECODE, OType.STRING);
        type.createIndex(I_USERNAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_USERNAME});
        type.createIndex(I_NAMECODE, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAMECODE});
    }

    protected UserTokenRecord newEntity() {
        throw new UnsupportedOperationException();
    }

    protected void readFields(ODocument document, UserTokenRecord entity) {
        throw new UnsupportedOperationException();
    }

    public UserTokenRecord readEntity(ODocument document) {
        PrincipalCollection principals = UserTokenRecordEntityAdapter.deserialize((byte[])document.field(P_PRINCIPALS));
        String nameCode = (String)document.field(P_NAMECODE);
        String passCode = (String)document.field(P_PASSCODE);
        UserToken token = new UserToken(nameCode, passCode);
        Date created = (Date)document.field(P_CREATED);
        UserTokenRecord entity = new UserTokenRecord(principals, token, created);
        this.attachMetadata((Entity)entity, document);
        return entity;
    }

    protected void writeFields(ODocument document, UserTokenRecord entity) {
        document.field(P_PRINCIPALS, (Object)UserTokenRecordEntityAdapter.serialize(entity.getPrincipals()));
        document.field(P_USERNAME, (Object)entity.getUserName());
        document.field(P_NAMECODE, (Object)entity.getNameCode());
        document.field(P_PASSCODE, (Object)new String(entity.getPassCode()));
        document.field(P_CREATED, (Object)entity.getCreated());
    }

    public long count(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(COUNT_QUERY)).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("COUNT");
    }

    public boolean contains(ODatabaseDocumentTx db, String username) {
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(CONTAINS_QUERY)).execute(new Object[]{username});
        return (Long)((ODocument)result.get(0)).field("COUNT") > 0L;
    }

    @Nullable
    public UserTokenRecord get(ODatabaseDocumentTx db, String principal, boolean allowUsername, boolean allowNameCode) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)principal);
        List result = null;
        if (allowUsername) {
            result = allowNameCode ? (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_OR_NAMECODE_QUERY)).execute(new Object[]{principal, principal}) : (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{principal});
        } else if (allowNameCode) {
            result = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_NAMECODE_QUERY)).execute(new Object[]{principal});
        }
        return result == null || result.isEmpty() ? null : this.readEntity((ODocument)result.get(0));
    }

    public Iterator<UserTokenRecord> getAll(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        return Iterators.transform((Iterator)db.browseClass(DB_CLASS).iterator(), (Function)new Function<ODocument, UserTokenRecord>(){

            public UserTokenRecord apply(ODocument document) {
                return UserTokenRecordEntityAdapter.this.readEntity(document);
            }
        });
    }

    private static PrincipalCollection deserialize(byte[] bytes) {
        try {
            return (PrincipalCollection)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] serialize(PrincipalCollection object) {
        try {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buff);
            out.writeObject(object);
            out.close();
            return buff.toByteArray();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public boolean deleteByUsername(ODatabaseDocumentTx db, String username) {
        return this.deleteByUsername.execute(db, new Object[]{username});
    }
}

