/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletContextListener;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.SisuExtender;
import org.eclipse.sisu.launch.SisuTracker;
import org.osgi.framework.BundleContext;
import org.sonatype.nexus.extender.NexusBundleTracker;
import org.sonatype.nexus.extender.NexusContextListener;

public class NexusBundleExtender
extends SisuExtender {
    private BundleContext context;
    private NexusContextListener listener;
    private boolean activated;

    public void start(BundleContext ctx) {
        this.context = ctx;
        this.listener = new NexusContextListener(this);
        Hashtable<String, String> listenerProperties = new Hashtable<String, String>();
        ((Dictionary)listenerProperties).put("name", "nexus");
        ctx.registerService(ServletContextListener.class, (Object)this.listener, listenerProperties);
    }

    public void stop(BundleContext ctx) {
        if (this.listener != null) {
            this.listener.contextDestroyed(null);
            this.listener = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void doStart() {
        super.start(this.context);
        this.activated = true;
    }

    public void doStop() {
        this.listener = null;
        if (this.activated) {
            this.activated = false;
            super.stop(this.context);
        }
    }

    protected SisuTracker createTracker(BundleContext ctx) {
        return new NexusBundleTracker(ctx, this.createLocator(ctx));
    }

    protected MutableBeanLocator createLocator(BundleContext ctx) {
        return (MutableBeanLocator)this.listener.getInjector().getInstance(MutableBeanLocator.class);
    }
}

