/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import com.google.inject.Key;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.bean.LifecycleModule;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.SisuBundlePlan;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.ParameterKeys;
import org.osgi.framework.Bundle;
import org.sonatype.nexus.common.guice.AbstractInterceptorModule;
import org.sonatype.nexus.common.guice.TypeConverterSupport;
import org.sonatype.nexus.extender.modules.NexusBundleModule;
import org.sonatype.nexus.extender.modules.ServletContextModule;

public class NexusBundlePlan
extends SisuBundlePlan {
    private final Map<?, ?> nexusProperties;
    private final ServletContextModule servletContextModule;
    private final List<AbstractInterceptorModule> interceptorModules;
    private final List<TypeConverterSupport> converterModules;
    private final LifecycleModule lifecycleModule;

    public NexusBundlePlan(MutableBeanLocator locator) {
        super(locator);
        this.nexusProperties = (Map)NexusBundlePlan.getFirstValue(locator.locate(ParameterKeys.PROPERTIES));
        this.servletContextModule = new ServletContextModule((ServletContext)NexusBundlePlan.getFirstValue(locator.locate(Key.get(ServletContext.class))));
        this.interceptorModules = new EntryListAdapter(locator.locate(Key.get(AbstractInterceptorModule.class)));
        this.converterModules = new EntryListAdapter(locator.locate(Key.get(TypeConverterSupport.class)));
        this.lifecycleModule = new LifecycleModule();
    }

    protected boolean appliesTo(Bundle bundle) {
        return true;
    }

    protected Module compose(Bundle bundle) {
        return new NexusBundleModule(bundle, this.locator, this.nexusProperties, this.servletContextModule, this.interceptorModules, this.converterModules, this.lifecycleModule);
    }

    private static <T> T getFirstValue(Iterable<? extends BeanEntry<?, T>> entries) {
        return (T)entries.iterator().next().getValue();
    }
}

