/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundlePlan;
import org.eclipse.sisu.launch.SisuTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.extender.NexusBundlePlan;

public class NexusBundleTracker
extends SisuTracker {
    private static final Logger log = LoggerFactory.getLogger(NexusBundleTracker.class);
    private final Set<String> visited = new HashSet<String>();
    private final Bundle systemBundle;
    private boolean closing = false;

    public NexusBundleTracker(BundleContext context, MutableBeanLocator locator) {
        super(context, 40, locator);
        this.systemBundle = context.getBundle(0L);
    }

    protected List<BundlePlan> discoverPlans() {
        return Collections.singletonList(new NexusBundlePlan(this.locator));
    }

    public BindingPublisher prepare(Bundle bundle) {
        if (NexusBundleTracker.hasComponents(bundle)) {
            if ("org.ops4j.pax.url.mvn".equals(bundle.getSymbolicName())) {
                return null;
            }
            this.prepareDependencies(bundle);
            try {
                log.info("ACTIVATING {}", (Object)bundle);
                BindingPublisher publisher = super.prepare(bundle);
                log.info("ACTIVATED {}", (Object)bundle);
                return publisher;
            }
            catch (Exception e) {
                log.warn("BROKEN {}", (Object)bundle);
                throw e;
            }
        }
        if (bundle.getBundleContext() == this.context) {
            this.prepareDependencies(bundle);
        }
        return null;
    }

    public void close() {
        try {
            this.closing = true;
            this.purgeBundles();
            super.close();
        }
        finally {
            this.closing = false;
            this.visited.clear();
        }
    }

    protected boolean evictBundle(Bundle bundle) {
        return this.closing || super.evictBundle(bundle) && (this.systemBundle.getState() & 0x10) == 0;
    }

    private void prepareDependencies(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List wires = wiring.getRequiredWires("osgi.wiring.package");
        if (wires != null) {
            for (BundleWire wire : wires) {
                try {
                    Bundle dependency = wire.getProviderWiring().getBundle();
                    if (!this.visited.add(dependency.getSymbolicName()) || !NexusBundleTracker.hasComponents(dependency)) continue;
                    if (!NexusBundleTracker.live(dependency)) {
                        dependency.start();
                    }
                    if (!NexusBundleTracker.live(dependency)) continue;
                    this.addingBundle(dependency, null);
                }
                catch (Exception e) {
                    log.warn("MISSING {}", (Object)wire, (Object)e);
                }
            }
        }
    }

    private static boolean hasComponents(Bundle bundle) {
        return bundle.getResource("META-INF/sisu/javax.inject.Named") != null;
    }

    private static boolean live(Bundle bundle) {
        return (bundle.getState() & 0x28) != 0;
    }
}

