/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import java.util.Map;
import javax.servlet.ServletContext;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.osgi.ServiceBindings;
import org.eclipse.sisu.wire.ParameterKeys;
import org.osgi.framework.BundleContext;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.common.guice.TimeTypeConverter;
import org.sonatype.nexus.common.stateguard.StateGuardModule;
import org.sonatype.nexus.extender.NexusLifecycleManager;
import org.sonatype.nexus.security.WebSecurityModule;
import org.sonatype.nexus.transaction.TransactionModule;

public class NexusContextModule
extends AbstractModule {
    private static final String ALLOW_SERVICES = "org.apache.karaf.*,org.sonatype.nexus.*," + ServiceBindings.defaultAllow();
    private static final String IGNORE_SERVICES = "org.apache.karaf.shell.commands.*," + ServiceBindings.defaultIgnore();
    private final BundleContext bundleContext;
    private final ServletContext servletContext;
    private final Map<?, ?> nexusProperties;

    public NexusContextModule(BundleContext bundleContext, ServletContext servletContext, Map<?, ?> nexusProperties) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.servletContext = (ServletContext)Preconditions.checkNotNull((Object)servletContext);
        this.nexusProperties = (Map)Preconditions.checkNotNull(nexusProperties);
    }

    protected void configure() {
        this.requireBinding(GuiceFilter.class);
        this.requireBinding(BeanManager.class);
        this.bind(ManagedLifecycleManager.class).to(NexusLifecycleManager.class);
        this.bind(ServletContext.class).toInstance((Object)this.servletContext);
        this.bind(ParameterKeys.PROPERTIES).toInstance(this.nexusProperties);
        this.install((Module)new StateGuardModule());
        this.install((Module)new TransactionModule());
        this.install((Module)new TimeTypeConverter());
        this.install((Module)new WebSecurityModule(this.servletContext));
        DefaultBeanLocator locator = new DefaultBeanLocator();
        locator.add((BindingPublisher)new ServiceBindings(this.bundleContext, ALLOW_SERVICES, IGNORE_SERVICES, Integer.MIN_VALUE));
        this.bind(MutableBeanLocator.class).toInstance((Object)locator);
    }
}

