/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules;

import com.google.common.base.Strings;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shiro.guice.aop.ShiroAopModule;
import org.eclipse.sisu.bean.LifecycleModule;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.osgi.framework.Bundle;
import org.sonatype.nexus.common.guice.AbstractInterceptorModule;
import org.sonatype.nexus.common.guice.TypeConverterSupport;
import org.sonatype.nexus.extender.modules.InstrumentationModule;
import org.sonatype.nexus.extender.modules.MetricsRegistryModule;
import org.sonatype.nexus.extender.modules.RankingModule;
import org.sonatype.nexus.extender.modules.SecurityFilterModule;
import org.sonatype.nexus.extender.modules.ServletContextModule;
import org.sonatype.nexus.extender.modules.WebResourcesModule;
import org.sonatype.nexus.validation.ValidationModule;

public class NexusBundleModule
extends BundleModule {
    private static final ShiroAopModule shiroAopModule = new ShiroAopModule();
    private static final SecurityFilterModule securityFilterModule = new SecurityFilterModule();
    private static final MetricsRegistryModule metricsRegistryModule = new MetricsRegistryModule();
    private static final InstrumentationModule instrumentationModule = new InstrumentationModule();
    private static final ValidationModule validationModule = new ValidationModule();
    private static final WebResourcesModule webResourcesModule = new WebResourcesModule();
    private static final RankingModule rankingModule = new RankingModule();
    private final Map<?, ?> nexusProperties;
    private final ServletContextModule servletContextModule;
    private final List<AbstractInterceptorModule> interceptorModules;
    private final List<TypeConverterSupport> converterModules;
    private final LifecycleModule lifecycleModule;
    private final String imports;

    public NexusBundleModule(Bundle bundle, MutableBeanLocator locator, Map<?, ?> nexusProperties, ServletContextModule servletContextModule, List<AbstractInterceptorModule> interceptorModules, List<TypeConverterSupport> converterModules, LifecycleModule lifecycleModule) {
        super(bundle, locator);
        this.nexusProperties = nexusProperties;
        this.servletContextModule = servletContextModule;
        this.interceptorModules = interceptorModules;
        this.converterModules = converterModules;
        this.lifecycleModule = lifecycleModule;
        this.imports = Strings.nullToEmpty((String)((String)bundle.getHeaders().get("Import-Package")));
    }

    protected List<Module> modules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        this.maybeAddSecurityFilter(modules);
        this.maybeAddServletContext(modules);
        this.maybeAddMetricsRegistry(modules);
        this.maybeAddWebResources(modules);
        this.addInterceptors(modules);
        modules.addAll(super.modules());
        modules.addAll(this.converterModules);
        modules.add((Module)rankingModule);
        return modules;
    }

    protected Map<?, ?> getProperties() {
        return this.nexusProperties;
    }

    protected Module spaceModule() {
        return new SpaceModule((ClassSpace)this.space, BeanScanning.GLOBAL_INDEX);
    }

    private void maybeAddSecurityFilter(List<Module> modules) {
        if (this.imports.contains("org.sonatype.nexus.security")) {
            modules.add((Module)securityFilterModule);
        }
    }

    private void maybeAddServletContext(List<Module> modules) {
        if (this.imports.contains("com.google.inject.servlet")) {
            modules.add((Module)this.servletContextModule);
        }
    }

    private void maybeAddMetricsRegistry(List<Module> modules) {
        if (this.imports.contains("com.codahale.metrics")) {
            modules.add((Module)metricsRegistryModule);
        }
    }

    private void maybeAddWebResources(List<Module> modules) {
        if (this.space.getBundle().getEntry("static") != null) {
            modules.add((Module)webResourcesModule);
        }
    }

    private void addInterceptors(List<Module> modules) {
        modules.add((Module)shiroAopModule);
        modules.add((Module)instrumentationModule);
        modules.add((Module)validationModule);
        for (AbstractInterceptorModule aim : this.interceptorModules) {
            modules.add((Module)aim);
        }
        modules.add((Module)this.lifecycleModule);
    }
}

