/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.selector.VariableResolver;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.selector.VariableSourceBuilder;

public class ConstantVariableResolver
implements VariableResolver {
    private final Set<String> variables;
    private final Object value;

    public ConstantVariableResolver(Object value, String ... variables) {
        this.variables = Collections.unmodifiableSet(Arrays.stream(variables).collect(Collectors.toSet()));
        this.value = value;
    }

    @Override
    public Optional<Object> resolve(String variable) {
        if (this.variables.contains(variable)) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    @Override
    public Set<String> getVariableSet() {
        return this.variables;
    }

    public static VariableSource sourceFor(Object value, String ... variables) {
        return new VariableSourceBuilder().addResolver(new ConstantVariableResolver(value, variables)).build();
    }
}

