/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.selector.AbstractCselParserVisitor;
import org.sonatype.nexus.selector.CselAssetSql;
import org.sonatype.nexus.selector.JexlSelector;
import org.sonatype.nexus.selector.LeadingSlashRegexTransformer;

@Named
@Singleton
public class CselAssetSqlBuilder
extends AbstractCselParserVisitor {
    private static final String FORMAT_PLACEHOLDER = "${format}";
    private static final String PATH = "path";
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final JexlInfo CALLER_INFO = new JexlInfo(JexlSelector.class.getName(), 0, 0);

    public CselAssetSql buildWhereClause(String expression, String format, String parameterPrefix, String fieldPrefix) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)expression) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parameterPrefix) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)fieldPrefix);
        Parser parser = new Parser((Reader)new StringReader(";"));
        ASTJexlScript parseTree = parser.parse(CALLER_INFO, expression, null, false, true);
        CselAssetSql cselAssetSql = (CselAssetSql)this.visit(parseTree, (Object)new CselAssetSql(parameterPrefix, fieldPrefix));
        StringBuilder whereClause = cselAssetSql.getSqlBuilder();
        int i = whereClause.indexOf(FORMAT_PLACEHOLDER);
        while (i >= 0) {
            whereClause.replace(i, i + FORMAT_PLACEHOLDER.length(), format);
            i = whereClause.indexOf(FORMAT_PLACEHOLDER);
        }
        return cselAssetSql;
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        CselAssetSql cselAssetSql = (CselAssetSql)data;
        StringBuilder result = cselAssetSql.getSqlBuilder();
        ASTIdentifierAccess childNode = (ASTIdentifierAccess)node.jjtGetChild(1);
        return result.append(cselAssetSql.getFieldPrefix()).append("attributes.").append(FORMAT_PLACEHOLDER).append(".").append(childNode.getName());
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        return this.visitOperator((JexlNode)node, "or", data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return this.visitOperator((JexlNode)node, "and", data);
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return this.visitOperator((JexlNode)node, "=", data);
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        return this.visitOperator((JexlNode)node, "<>", data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        return this.visitOperator((JexlNode)node, "matches", data);
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        StringBuilder result = this.visitOperator((JexlNode)node, "like", data);
        CselAssetSql cselAssetSql = (CselAssetSql)data;
        String lastParameterName = cselAssetSql.getLastParameterName();
        if (lastParameterName != null) {
            Map<String, Object> parameters = cselAssetSql.getSqlParameters();
            Object parameter = parameters.get(lastParameterName);
            if (parameter instanceof String) {
                parameters.put(lastParameterName, parameters.get(lastParameterName) + "%");
                return result;
            }
            throw new JexlException((JexlNode)node, "Starts with expression must be assigned a string value");
        }
        throw new JexlException((JexlNode)node, "No parameters are defined");
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        CselAssetSql cselAssetSql = (CselAssetSql)data;
        StringBuilder result = cselAssetSql.getSqlBuilder();
        if (Objects.equals(PATH, node.getName())) {
            result.append(cselAssetSql.getFieldPrefix()).append("name");
        } else if (Objects.equals("format", node.getName())) {
            result.append(cselAssetSql.getFieldPrefix()).append("format");
        }
        return result;
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        return this.appendStringParameter((CselAssetSql)data, node.getLiteral());
    }

    private StringBuilder appendStringParameter(CselAssetSql cselAssetSql, String string) {
        String parameterName = cselAssetSql.getNextParameterName();
        cselAssetSql.getSqlParameters().put(parameterName, string);
        return cselAssetSql.getSqlBuilder().append(String.valueOf(':') + parameterName);
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        CselAssetSql cselAssetSql = (CselAssetSql)data;
        StringBuilder result = cselAssetSql.getSqlBuilder();
        result.append('(');
        node.childrenAccept((ParserVisitor)this, data);
        result.append(')');
        return result;
    }

    private StringBuilder visitOperator(JexlNode node, String operator, Object data) {
        JexlNode rightChild;
        CselAssetSql cselAssetSql = (CselAssetSql)data;
        StringBuilder result = cselAssetSql.getSqlBuilder();
        JexlNode leftChild = node.jjtGetChild(0);
        if (this.isPathNode(leftChild, rightChild = node.jjtGetChild(1)) || this.isPathNode(rightChild, leftChild)) {
            this.visitPath(cselAssetSql, leftChild, rightChild, operator);
        } else if (this.isNotEqualsOperator(operator)) {
            this.visitNotEqualsOperator(cselAssetSql, leftChild, rightChild, operator);
        } else {
            leftChild.jjtAccept((ParserVisitor)this, data);
            result.append(' ').append(operator).append(' ');
            rightChild.jjtAccept((ParserVisitor)this, data);
        }
        return result;
    }

    private void visitNotEqualsOperator(CselAssetSql cselAssetSql, JexlNode leftChild, JexlNode rightChild, String operator) {
        StringBuilder result = cselAssetSql.getSqlBuilder();
        JexlNode varNode = rightChild;
        JexlNode stringNode = leftChild;
        if (this.isStringNode(rightChild)) {
            varNode = leftChild;
            stringNode = rightChild;
        }
        result.append("(");
        varNode.jjtAccept((ParserVisitor)this, (Object)cselAssetSql);
        result.append(" is null or ");
        varNode.jjtAccept((ParserVisitor)this, (Object)cselAssetSql);
        result.append(" ").append(operator).append(" ");
        stringNode.jjtAccept((ParserVisitor)this, (Object)cselAssetSql);
        result.append(")");
    }

    private Object visitPath(CselAssetSql cselAssetSql, JexlNode left, JexlNode right, String operator) {
        StringBuilder result = cselAssetSql.getSqlBuilder();
        JexlNode identifier = left instanceof ASTIdentifier ? left : right;
        ASTStringLiteral string = (ASTStringLiteral)(right instanceof ASTStringLiteral ? right : left);
        identifier.jjtAccept((ParserVisitor)this, (Object)cselAssetSql);
        result.append(' ').append(operator).append(' ');
        this.appendStringParameter(cselAssetSql, LeadingSlashRegexTransformer.trimLeadingSlashes(string.getLiteral()));
        return result;
    }

    private boolean isPathNode(JexlNode identifier, JexlNode literal) {
        return identifier instanceof ASTIdentifier && literal instanceof ASTStringLiteral && PATH.equals(((ASTIdentifier)identifier).getName());
    }

    private boolean isStringNode(JexlNode node) {
        return node instanceof ASTStringLiteral;
    }

    private boolean isNotEqualsOperator(String operator) {
        return "<>".equals(operator);
    }
}

