/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import org.apache.commons.jexl3.JexlException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.selector.CselSelector;
import org.sonatype.nexus.selector.CselValidator;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Singleton
public class CselExpressionValidator
extends ComponentSupport {
    private final ConstraintViolationFactory constraintViolationFactory;
    private final CselValidator validator;

    @Inject
    public CselExpressionValidator(ConstraintViolationFactory constraintViolationFactory, CselValidator validator) {
        this.constraintViolationFactory = constraintViolationFactory;
        this.validator = validator;
    }

    public void validate(String expression) {
        try {
            this.validator.validate(expression);
        }
        catch (Exception e) {
            String msg = e instanceof JexlException ? CselSelector.prettyExceptionMsg((JexlException)e) : e.getMessage();
            this.log.debug(msg, (Throwable)e);
            throw new ConstraintViolationException(e.getMessage(), Collections.singleton(this.constraintViolationFactory.createViolation("expression", msg)));
        }
    }
}

