/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.selector.AbstractCselParserVisitor;
import org.sonatype.nexus.selector.JexlSelector;

@Named
@Singleton
public class CselValidator
extends AbstractCselParserVisitor {
    private static final JexlInfo CALLER_INFO = new JexlInfo(JexlSelector.class.getName(), 0, 0);
    private final Parser parser = new Parser((Reader)new StringReader(";"));

    public boolean validate(String expression) {
        ASTJexlScript parseTree = this.parser.parse(CALLER_INFO, expression, null, false, true);
        Boolean result = true;
        return (Boolean)this.visit(parseTree, (Object)result);
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        List<String> parentNames = Arrays.asList("coordinate");
        List<String> childNames = Arrays.asList("groupId", "artifactId", "version", "extension", "classifier", "id");
        if (node.jjtGetNumChildren() == 2) {
            ASTIdentifier parentNode = (ASTIdentifier)node.jjtGetChild(0);
            ASTIdentifierAccess childNode = (ASTIdentifierAccess)node.jjtGetChild(1);
            if (parentNames.contains(parentNode.getName()) && childNames.contains(childNode.getName())) {
                return data;
            }
            throw new JexlException((JexlNode)node, "'Invalid identifier=" + parentNode.getName() + '.' + childNode.getName() + ", expected one of " + parentNames + '.' + childNames + "'");
        }
        throw new JexlException((JexlNode)node, "'Invalid reference - too long'");
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        List<String> validNames = Arrays.asList("format", "path");
        if (validNames.contains(node.getName())) {
            return node.childrenAccept((ParserVisitor)this, data);
        }
        throw new JexlException((JexlNode)node, "'Invalid identifier=" + node.getName() + ", expected one of " + validNames + "'");
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        String literal = node.getLiteral();
        if (literal.contains("\"") || literal.contains("'")) {
            throw new UnsupportedOperationException("String literal " + literal + " should not contain embedded strings (\" or ')");
        }
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }
}

