/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import org.apache.commons.jexl3.JexlException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.selector.JexlSelector;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Singleton
public class JexlExpressionValidator
extends ComponentSupport {
    private final ConstraintViolationFactory constraintViolationFactory;

    @Inject
    public JexlExpressionValidator(ConstraintViolationFactory constraintViolationFactory) {
        this.constraintViolationFactory = constraintViolationFactory;
    }

    public void validate(String expression) {
        try {
            new JexlSelector(expression);
        }
        catch (Exception e) {
            String msg = e instanceof JexlException ? JexlSelector.prettyExceptionMsg((JexlException)e) : e.getMessage();
            this.log.debug(msg, (Throwable)e);
            throw new ConstraintViolationException(e.getMessage(), Collections.singleton(this.constraintViolationFactory.createViolation("expression", msg)));
        }
    }
}

