/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.selector.Selector;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.selector.internal.SandboxJexlUberspect;

public class JexlSelector
implements Selector {
    public static final String TYPE = "jexl";
    private static final JexlInfo CALLER_INFO = new JexlInfo(JexlSelector.class.getName(), 0, 0);
    private static final JexlEngine jexlEngine = new JexlBuilder().uberspect((JexlUberspect)new SandboxJexlUberspect()).create();
    private final Optional<JexlExpression> expression;

    public JexlSelector(String expression) {
        this.expression = Strings.isNullOrEmpty((String)expression) ? Optional.empty() : Optional.of(jexlEngine.createExpression(CALLER_INFO, expression));
    }

    @Override
    public boolean evaluate(VariableSource variableSource) {
        if (this.expression.isPresent()) {
            Set<String> vars = variableSource.getVariableSet();
            MapContext jc = new MapContext();
            vars.forEach(arg_0 -> JexlSelector.lambda$0(variableSource, (JexlContext)jc, arg_0));
            Object o = this.expression.get().evaluate((JexlContext)jc);
            return o instanceof Boolean ? (Boolean)o : false;
        }
        return true;
    }

    public String getSourceText() {
        return this.expression.map(JexlExpression::getSourceText).orElse("");
    }

    public static String prettyExceptionMsg(JexlException e) {
        JexlInfo info = e.getInfo();
        if (info != null) {
            String detail = e.getMessage();
            if (!Strings2.isBlank((String)detail) && detail.indexOf(39) > -1) {
                detail = e.getMessage().substring(detail.indexOf(39) + 1, detail.lastIndexOf(39));
            }
            String parseMsg = detail.isEmpty() ? detail : String.format(" Error parsing string: '%s'.", detail);
            return String.format("Invalid JEXL at line '%s' column '%s'.%s", info.getLine(), info.getColumn(), parseMsg);
        }
        return e.getMessage();
    }

    public String toString() {
        return this.expression.isPresent() ? this.expression.get().getParsedText() : "";
    }

    private static /* synthetic */ void lambda$0(VariableSource variableSource, JexlContext jexlContext, String variable) {
        variableSource.get(variable).ifPresent(value -> jexlContext.set(variable, value));
    }
}

