/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;

public class LeadingSlashRegexTransformer {
    private final String regex;
    private StringBuilder buf;
    private int mark;
    private int cursor;

    public static String trimLeadingSlashes(String regex) {
        return new LeadingSlashRegexTransformer(regex).transform();
    }

    private LeadingSlashRegexTransformer(String regex) {
        this.regex = (String)Preconditions.checkNotNull((Object)regex);
    }

    public String transform() {
        this.transformGroup(false);
        return this.buf == null ? this.regex : this.buf.append(this.regex, this.mark, this.regex.length()).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean transformGroup(boolean hasPrecedingWildcard) {
        boolean noEmptyClauses = true;
        boolean hasLeadingText = false;
        boolean hasWildcard = false;
        block10: while (this.hasChar()) {
            switch (this.consumeNextChar()) {
                case '/': {
                    if (hasLeadingText) break;
                    this.transformLeadingSlash(hasPrecedingWildcard || hasWildcard);
                    break;
                }
                case '\\': {
                    this.consumeNextChar();
                    break;
                }
                case '[': {
                    this.consumeRange();
                    break;
                }
                case '(': {
                    if (!hasLeadingText) {
                        boolean lookaround = this.consumeLookaroundOptions();
                        hasLeadingText = this.transformGroup(hasPrecedingWildcard || hasWildcard);
                        if (!lookaround) continue block10;
                        hasLeadingText = false;
                        continue block10;
                    }
                    this.consumeGroup();
                    break;
                }
                case '|': {
                    noEmptyClauses &= hasLeadingText;
                    hasLeadingText = false;
                    hasWildcard = false;
                    continue block10;
                }
                case ')': {
                    return noEmptyClauses &= hasLeadingText;
                }
                case '*': 
                case '?': {
                    hasLeadingText = false;
                    hasWildcard = true;
                    continue block10;
                }
                case '$': 
                case '^': {
                    continue block10;
                }
            }
            if (hasLeadingText) {
                this.consumeClause();
                continue;
            }
            hasLeadingText = true;
        }
        return noEmptyClauses;
    }

    private void transformLeadingSlash(boolean hasPrecedingWildcard) {
        if (this.hasChar() && (this.peekNextChar() == '?' || this.peekNextChar() == '*')) {
            return;
        }
        if (this.buf == null) {
            this.buf = new StringBuilder(this.regex.length() + 16);
        }
        this.buf.append(this.regex, this.mark, this.cursor - 1);
        if (hasPrecedingWildcard || this.hasChar() && this.peekNextChar() == '+') {
            this.buf.append("(^|/)");
        }
        this.mark = this.cursor;
    }

    private boolean consumeLookaroundOptions() {
        if (this.hasChar() && this.peekNextChar() == '?') {
            this.consumeNextChar();
            if (this.hasChar() && this.peekNextChar() == '<') {
                this.consumeNextChar();
            }
            if (this.hasChar() && this.peekNextChar() == '!') {
                this.consumeNextChar();
                return true;
            }
        }
        return false;
    }

    private void consumeClause() {
        while (this.hasChar() && this.peekNextChar() != ')' && this.peekNextChar() != '|') {
            switch (this.consumeNextChar()) {
                case '\\': {
                    this.consumeNextChar();
                    break;
                }
                case '[': {
                    this.consumeRange();
                    break;
                }
                case '(': {
                    this.consumeGroup();
                    break;
                }
            }
        }
    }

    private void consumeGroup() {
        int nesting = 1;
        while (nesting > 0 && this.hasChar()) {
            switch (this.consumeNextChar()) {
                case '\\': {
                    this.consumeNextChar();
                    break;
                }
                case '[': {
                    this.consumeRange();
                    break;
                }
                case '(': {
                    ++nesting;
                    break;
                }
                case ')': {
                    --nesting;
                    break;
                }
            }
        }
    }

    private void consumeRange() {
        int nesting = 1;
        while (nesting > 0 && this.hasChar()) {
            switch (this.consumeNextChar()) {
                case '\\': {
                    this.consumeNextChar();
                    break;
                }
                case '[': {
                    ++nesting;
                    break;
                }
                case ']': {
                    --nesting;
                    break;
                }
            }
        }
    }

    private boolean hasChar() {
        return this.cursor < this.regex.length();
    }

    private char peekNextChar() {
        return this.regex.charAt(this.cursor);
    }

    private char consumeNextChar() {
        return this.regex.charAt(this.cursor++);
    }
}

