/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.UniqueSelectorName;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class UniqueSelectorNameValidator
extends ConstraintValidatorSupport<UniqueSelectorName, String> {
    private final SelectorManager selectorManager;

    @Inject
    public UniqueSelectorNameValidator(SelectorManager selectorManager) {
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        this.log.trace("Validating unique selector name: {}", (Object)value);
        for (SelectorConfiguration configuration : this.selectorManager.browse()) {
            if (!value.equals(configuration.getName())) continue;
            return false;
        }
        return true;
    }
}

