/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation;

import com.google.common.base.Preconditions;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Constraint;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Payload;
import javax.validation.Validator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
@Singleton
public class ConstraintViolationFactory
extends ComponentSupport {
    private final Provider<Validator> validatorProvider;

    @Inject
    public ConstraintViolationFactory(Provider<Validator> validatorProvider) {
        this.validatorProvider = (Provider)Preconditions.checkNotNull(validatorProvider);
    }

    public ConstraintViolation<?> createViolation(String path, String message) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)message);
        return (ConstraintViolation)((Validator)this.validatorProvider.get()).validate((Object)new HelperBean(path, message), new Class[0]).iterator().next();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={HelperValidator.class})
    @Documented
    private static @interface HelperAnnotation {
        public String message() default "";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    @HelperAnnotation
    private static class HelperBean {
        private final String path;
        private final String message;

        public HelperBean(String path, String message) {
            this.path = path;
            this.message = message;
        }

        public String getPath() {
            return this.path;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class HelperValidator
    extends ConstraintValidatorSupport<HelperAnnotation, HelperBean> {
        private HelperValidator() {
        }

        public boolean isValid(HelperBean bean, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(bean.getMessage());
            ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext nodeBuilder = null;
            String[] stringArray = bean.getPath().split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                nodeBuilder = nodeBuilder == null ? builder.addPropertyNode(part) : nodeBuilder.addPropertyNode(part);
                ++n2;
            }
            if (nodeBuilder != null) {
                nodeBuilder.addConstraintViolation();
            }
            return false;
        }
    }
}

