/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import javax.inject.Singleton;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInterceptor;
import org.hibernate.validator.HibernateValidator;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.internal.AlwaysTraversableResolver;
import org.sonatype.nexus.validation.internal.AopAwareParanamerParameterNameProvider;
import org.sonatype.nexus.validation.internal.GuiceConstraintValidatorFactory;
import org.sonatype.nexus.validation.internal.ValidationInterceptor;

public class ValidationModule
extends AbstractModule {
    protected void configure() {
        ValidationInterceptor interceptor = new ValidationInterceptor();
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Validate.class), new MethodInterceptor[]{interceptor});
        this.requestInjection(interceptor);
        this.bind(ConstraintValidatorFactory.class).to(GuiceConstraintValidatorFactory.class);
    }

    @Provides
    @Singleton
    ValidatorFactory validatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory factory = Validation.byDefaultProvider().configure().constraintValidatorFactory(constraintValidatorFactory).parameterNameProvider((ParameterNameProvider)new AopAwareParanamerParameterNameProvider()).traversableResolver((TraversableResolver)new AlwaysTraversableResolver()).buildValidatorFactory();
            factory.getValidator().validate(new Object(){
                @NotNull(message="${0}")
                String empty;
            }, new Class[0]);
            ValidatorFactory validatorFactory = factory;
            return validatorFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Provides
    @Singleton
    Validator validator(ValidatorFactory validatorFactory) {
        return validatorFactory.getValidator();
    }

    @Provides
    @Singleton
    ExecutableValidator executableValidator(Validator validator) {
        return validator.forExecutables();
    }
}

